/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.nurserostering.domain.Shift;

@XStreamAlias(value="ShiftDate")
public class ShiftDate
extends AbstractPersistable {
    private static final DateTimeFormatter LABEL_FORMATTER = DateTimeFormatter.ofPattern("E d MMM");
    private int dayIndex;
    private LocalDate date;
    private List<Shift> shiftList;

    public int getDayIndex() {
        return this.dayIndex;
    }

    public void setDayIndex(int dayIndex) {
        this.dayIndex = dayIndex;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public List<Shift> getShiftList() {
        return this.shiftList;
    }

    public void setShiftList(List<Shift> shiftList) {
        this.shiftList = shiftList;
    }

    public int getWeekendSundayIndex() {
        switch (this.date.getDayOfWeek()) {
            case MONDAY: {
                return this.dayIndex - 1;
            }
            case TUESDAY: {
                return this.dayIndex - 2;
            }
            case WEDNESDAY: {
                return this.dayIndex - 3;
            }
            case THURSDAY: {
                return this.dayIndex + 3;
            }
            case FRIDAY: {
                return this.dayIndex + 2;
            }
            case SATURDAY: {
                return this.dayIndex + 1;
            }
            case SUNDAY: {
                return this.dayIndex;
            }
        }
        throw new IllegalArgumentException("The dayOfWeek (" + this.date.getDayOfWeek() + ") is not valid.");
    }

    public String getLabel() {
        return this.date.format(LABEL_FORMATTER);
    }

    @Override
    public String toString() {
        return this.date.format(DateTimeFormatter.ISO_DATE);
    }
}

