/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kie.api.runtime.KieSession;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionEventSupport;
import org.optaplanner.core.impl.score.director.drools.testgen.TestGenKieSessionListener;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenInlineValue;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenNullFact;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenValueFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionDelete;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionFireAllRules;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionInsert;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenKieSessionJournal {
    private static final Logger logger = LoggerFactory.getLogger(TestGenKieSessionJournal.class);
    private final TestGenKieSessionEventSupport eventSupport = new TestGenKieSessionEventSupport();
    private final HashMap<Object, TestGenFact> existingInstances = new HashMap();
    private final List<TestGenFact> facts;
    private final List<TestGenKieSessionInsert> initialInsertJournal;
    private final List<TestGenKieSessionOperation> updateJournal;
    private int operationId = 0;
    private boolean assertMode = false;

    public TestGenKieSessionJournal() {
        this.facts = new ArrayList<TestGenFact>();
        this.initialInsertJournal = new ArrayList<TestGenKieSessionInsert>();
        this.updateJournal = new ArrayList<TestGenKieSessionOperation>();
    }

    public TestGenKieSessionJournal(List<TestGenFact> facts, List<TestGenKieSessionInsert> initialInsertJournal, List<TestGenKieSessionOperation> updateJournal) {
        this.facts = facts;
        this.initialInsertJournal = initialInsertJournal;
        this.updateJournal = updateJournal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(KieSession replayKieSession) {
        for (TestGenFact testGenFact : this.facts) {
            testGenFact.reset();
        }
        for (TestGenKieSessionOperation testGenKieSessionOperation : this.initialInsertJournal) {
            testGenKieSessionOperation.invoke(replayKieSession);
        }
        try {
            for (TestGenKieSessionOperation testGenKieSessionOperation : this.updateJournal) {
                testGenKieSessionOperation.invoke(replayKieSession);
                if (!testGenKieSessionOperation.getClass().equals(TestGenKieSessionFireAllRules.class)) continue;
                this.eventSupport.afterFireAllRules(replayKieSession, this, (TestGenKieSessionFireAllRules)testGenKieSessionOperation);
            }
        }
        finally {
            replayKieSession.dispose();
        }
    }

    public void addFacts(Collection<Object> workingFacts) {
        int i = 0;
        for (Object instance : workingFacts) {
            logger.trace("        Working fact added: {}[{}]", (Object)instance.getClass().getSimpleName(), instance);
            TestGenValueFact fact = new TestGenValueFact(i++, instance);
            this.facts.add(fact);
            this.existingInstances.put(instance, fact);
        }
        for (TestGenFact fact : this.facts) {
            fact.setUp(this.existingInstances);
        }
    }

    public void insertInitial(Object fact) {
        this.initialInsertJournal.add(new TestGenKieSessionInsert(this.operationId++, this.existingInstances.get(fact)));
    }

    public void insert(Object fact) {
        this.updateJournal.add(new TestGenKieSessionInsert(this.operationId++, this.existingInstances.get(fact)));
    }

    public void update(Object entity, VariableDescriptor<?> variableDescriptor) {
        TestGenFact valueFact;
        TestGenFact entityFact = this.existingInstances.get(entity);
        if (entityFact == null) {
            throw new IllegalStateException("The entity (" + entity.getClass().getSimpleName() + "[" + entity + "]) is not a working fact");
        }
        Object value = variableDescriptor.getValue(entity);
        TestGenFact testGenFact = valueFact = value == null ? TestGenNullFact.INSTANCE : this.existingInstances.get(value);
        if (valueFact == null) {
            valueFact = new TestGenInlineValue(value, this.existingInstances);
        }
        this.updateJournal.add(new TestGenKieSessionUpdate(this.operationId++, entityFact, variableDescriptor, valueFact));
    }

    public void delete(Object fact) {
        this.updateJournal.add(new TestGenKieSessionDelete(this.operationId++, this.existingInstances.get(fact)));
    }

    public void fireAllRules() {
        TestGenKieSessionFireAllRules fire = new TestGenKieSessionFireAllRules(this.operationId++, this.assertMode);
        logger.trace("        FIRE ALL RULES ({})", (Object)fire);
        this.updateJournal.add(fire);
    }

    public void dispose() {
        this.facts.clear();
        this.existingInstances.clear();
        this.initialInsertJournal.clear();
        this.updateJournal.clear();
        this.operationId = 0;
    }

    void enterAssertMode() {
        this.assertMode = true;
    }

    void exitAssertMode() {
        this.assertMode = false;
    }

    public void addListener(TestGenKieSessionListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeListener(TestGenKieSessionListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public List<TestGenFact> getFacts() {
        return this.facts;
    }

    public List<TestGenKieSessionInsert> getInitialInserts() {
        return this.initialInsertJournal;
    }

    public List<TestGenKieSessionOperation> getMoveOperations() {
        return this.updateJournal;
    }
}

