/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.AbstractSolverFactory;

public class XStreamXmlSolverFactory<Solution_>
extends AbstractSolverFactory<Solution_> {
    protected XStream xStream = XStreamXmlSolverFactory.buildXStream();

    public static XStream buildXStream() {
        XStream xStream = new XStream();
        String[] voidDeny = new String[]{"void.class", "Void.class"};
        xStream.denyTypes(voidDeny);
        xStream.setMode(1002);
        xStream.aliasSystemAttribute("xStreamId", "id");
        xStream.aliasSystemAttribute("xStreamRef", "reference");
        xStream.processAnnotations(SolverConfig.class);
        return xStream;
    }

    public XStreamXmlSolverFactory() {
        this(new SolverConfigContext());
    }

    public XStreamXmlSolverFactory(SolverConfigContext solverConfigContext) {
        super(solverConfigContext);
        ClassLoader actualClassLoader = solverConfigContext.determineActualClassLoader();
        this.xStream.setClassLoader(actualClassLoader);
    }

    public void addXStreamAnnotations(Class<?> ... xStreamAnnotations) {
        this.xStream.processAnnotations((Class[])xStreamAnnotations);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XStreamXmlSolverFactory<Solution_> configure(String solverConfigResource) {
        ClassLoader actualClassLoader = this.solverConfigContext.determineActualClassLoader();
        try (InputStream in = actualClassLoader.getResourceAsStream(solverConfigResource);){
            if (in == null) {
                String errorMessage = "The solverConfigResource (" + solverConfigResource + ") does not exist as a classpath resource in the classLoader (" + actualClassLoader + ").";
                if (!solverConfigResource.startsWith("/")) throw new IllegalArgumentException(errorMessage);
                errorMessage = errorMessage + "\nAs from 6.1, a classpath resource should not start with a slash (/). A solverConfigResource now adheres to ClassLoader.getResource(String). Remove the leading slash from the solverConfigResource if you're upgrading from 6.0.";
                throw new IllegalArgumentException(errorMessage);
            }
            XStreamXmlSolverFactory<Solution_> xStreamXmlSolverFactory = this.configure(in);
            return xStreamXmlSolverFactory;
        }
        catch (ConversionException e) {
            String string;
            String lineNumber = e.get("line number");
            StringBuilder stringBuilder = new StringBuilder().append("Unmarshalling of solverConfigResource (").append(solverConfigResource).append(") fails on line number (").append(lineNumber).append(").");
            if (Objects.equals(e.get("required-type"), "java.lang.Class")) {
                string = "\n  Maybe the classname on line number (" + lineNumber + ") is surrounded by whitespace, which is invalid.";
                throw new IllegalArgumentException(stringBuilder.append(string).toString(), e);
            }
            string = "";
            throw new IllegalArgumentException(stringBuilder.append(string).toString(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the solverConfigResource (" + solverConfigResource + ") failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XStreamXmlSolverFactory<Solution_> configure(File solverConfigFile) {
        try (FileInputStream in = new FileInputStream(solverConfigFile);){
            XStreamXmlSolverFactory<Solution_> xStreamXmlSolverFactory = this.configure(in);
            return xStreamXmlSolverFactory;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The solverConfigFile (" + solverConfigFile + ") was not found.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading the solverConfigFile (" + solverConfigFile + ") failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XStreamXmlSolverFactory<Solution_> configure(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, "UTF-8");){
            XStreamXmlSolverFactory<Solution_> xStreamXmlSolverFactory = this.configure(reader);
            return xStreamXmlSolverFactory;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("This vm does not support UTF-8 encoding.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Reading failed.", e);
        }
    }

    public XStreamXmlSolverFactory<Solution_> configure(Reader reader) {
        this.solverConfig = (SolverConfig)this.xStream.fromXML(reader);
        return this;
    }
}

