/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public abstract class AbstractCompositeTermination
extends AbstractTermination
implements Termination {
    protected final List<Termination> terminationList;

    protected AbstractCompositeTermination(List<Termination> terminationList) {
        this.terminationList = terminationList;
    }

    public AbstractCompositeTermination(Termination ... terminations) {
        this(Arrays.asList(terminations));
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            termination.solvingStarted(solverScope);
        }
    }

    public void phaseStarted(AbstractPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            termination.phaseStarted(phaseScope);
        }
    }

    public void stepStarted(AbstractStepScope stepScope) {
        for (Termination termination : this.terminationList) {
            termination.stepStarted(stepScope);
        }
    }

    public void stepEnded(AbstractStepScope stepScope) {
        for (Termination termination : this.terminationList) {
            termination.stepEnded(stepScope);
        }
    }

    public void phaseEnded(AbstractPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            termination.phaseEnded(phaseScope);
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            termination.solvingEnded(solverScope);
        }
    }

    protected List<Termination> createChildThreadTerminationList(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        ArrayList<Termination> childThreadTerminationList = new ArrayList<Termination>(this.terminationList.size());
        for (Termination termination : this.terminationList) {
            childThreadTerminationList.add(termination.createChildThreadTermination(solverScope, childThreadType));
        }
        return childThreadTerminationList;
    }
}

