/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.concurrent.Callable;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.SubSingleStatistic;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.config.SolverConfigContext;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SubSingleBenchmarkRunner<Solution_>
implements Callable<SubSingleBenchmarkRunner<Solution_>> {
    public static final String NAME_MDC = "subSingleBenchmark.name";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SubSingleBenchmarkResult subSingleBenchmarkResult;
    private final SolverConfigContext solverConfigContext;
    private final boolean warmUp;
    private Throwable failureThrowable = null;

    public SubSingleBenchmarkRunner(SubSingleBenchmarkResult subSingleBenchmarkResult, boolean warmUp) {
        this(subSingleBenchmarkResult, warmUp, new SolverConfigContext());
    }

    public SubSingleBenchmarkRunner(SubSingleBenchmarkResult subSingleBenchmarkResult, boolean warmUp, SolverConfigContext solverConfigContext) {
        this.subSingleBenchmarkResult = subSingleBenchmarkResult;
        this.warmUp = warmUp;
        this.solverConfigContext = solverConfigContext;
    }

    public SubSingleBenchmarkResult getSubSingleBenchmarkResult() {
        return this.subSingleBenchmarkResult;
    }

    public Throwable getFailureThrowable() {
        return this.failureThrowable;
    }

    public void setFailureThrowable(Throwable failureThrowable) {
        this.failureThrowable = failureThrowable;
    }

    @Override
    public SubSingleBenchmarkRunner<Solution_> call() {
        MDC.put((String)NAME_MDC, (String)this.subSingleBenchmarkResult.getName());
        Runtime runtime = Runtime.getRuntime();
        ProblemBenchmarkResult problemBenchmarkResult = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getProblemBenchmarkResult();
        Object problem = problemBenchmarkResult.readProblem();
        if (!problemBenchmarkResult.getPlannerBenchmarkResult().hasMultipleParallelBenchmarks()) {
            runtime.gc();
            this.subSingleBenchmarkResult.setUsedMemoryAfterInputSolution(runtime.totalMemory() - runtime.freeMemory());
        }
        this.logger.trace("Benchmark problem has been read for subSingleBenchmarkResult ({}).", (Object)this.subSingleBenchmarkResult);
        SolverConfig solverConfig = this.subSingleBenchmarkResult.getSingleBenchmarkResult().getSolverBenchmarkResult().getSolverConfig();
        if (this.subSingleBenchmarkResult.getSingleBenchmarkResult().getSubSingleCount() > 1) {
            solverConfig = new SolverConfig(solverConfig);
            solverConfig.offerRandomSeedFromSubSingleIndex((long)this.subSingleBenchmarkResult.getSubSingleBenchmarkIndex());
        }
        Solver solver = solverConfig.buildSolver(this.solverConfigContext);
        for (SubSingleStatistic subSingleStatistic : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic.open(solver);
            subSingleStatistic.initPointList();
        }
        Object solution = solver.solve(problem);
        long timeMillisSpent = solver.getTimeMillisSpent();
        DefaultSolverScope solverScope = ((DefaultSolver)solver).getSolverScope();
        SolutionDescriptor solutionDescriptor = solverScope.getSolutionDescriptor();
        problemBenchmarkResult.registerScale(solutionDescriptor.getEntityCount(solution), solutionDescriptor.getGenuineVariableCount(solution), solutionDescriptor.getMaximumValueCount(solution), solutionDescriptor.getProblemScale(solution));
        this.subSingleBenchmarkResult.setScore(solutionDescriptor.getScore(solution));
        this.subSingleBenchmarkResult.setTimeMillisSpent(timeMillisSpent);
        this.subSingleBenchmarkResult.setScoreCalculationCount(solverScope.getScoreCalculationCount());
        for (SubSingleStatistic subSingleStatistic : this.subSingleBenchmarkResult.getEffectiveSubSingleStatisticMap().values()) {
            subSingleStatistic.close(solver);
            subSingleStatistic.hibernatePointList();
        }
        if (!this.warmUp) {
            problemBenchmarkResult.writeSolution(this.subSingleBenchmarkResult, solution);
        }
        MDC.remove((String)NAME_MDC);
        return this;
    }

    public String getName() {
        return this.subSingleBenchmarkResult.getName();
    }

    public String toString() {
        return this.subSingleBenchmarkResult.toString();
    }
}

