/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.util.Date;
import java.util.TimeZone;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronExpression;
import org.kie.api.runtime.Calendars;
import org.kie.api.time.Calendar;

public class CronTrigger
implements Trigger {
    protected static final int YEAR_TO_GIVEUP_SCHEDULING_AT = 2299;
    private CronExpression cronEx = null;
    private Date startTime = null;
    private Date endTime = null;
    private int repeatLimit;
    private int repeatCount;
    private Date nextFireTime = null;
    private Date previousFireTime = null;
    private transient TimeZone timeZone = null;
    private String[] calendarNames;
    private Calendars calendars;

    public CronTrigger() {
    }

    public CronTrigger(long timestamp, Date startTime, Date endTime, int repeatLimit, String cronExpression, String[] calendarNames, Calendars calendars) {
        this(timestamp, startTime, endTime, repeatLimit, CronTrigger.determineCronExpression(cronExpression), calendarNames, calendars);
    }

    public CronTrigger(long timestamp, Date startTime, Date endTime, int repeatLimit, CronExpression cronExpression, String[] calendarNames, Calendars calendars) {
        this.setCronExpression(cronExpression);
        this.repeatLimit = repeatLimit;
        if (startTime == null) {
            startTime = new Date(timestamp);
        }
        this.setStartTime(startTime);
        if (endTime != null) {
            this.setEndTime(endTime);
        }
        this.setTimeZone(TimeZone.getDefault());
        this.nextFireTime = new Date(timestamp);
        this.setFirstFireTimeAfter();
        this.calendarNames = calendarNames;
        this.calendars = calendars;
        this.updateToNextIncludeDate();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("Start time cannot be null");
        }
        Date eTime = this.getEndTime();
        if (eTime != null && eTime.before(startTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        java.util.Calendar cl = java.util.Calendar.getInstance();
        cl.setTime(startTime);
        cl.set(14, 0);
        this.startTime = cl.getTime();
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        Date sTime = this.getStartTime();
        if (sTime != null && endTime != null && sTime.after(endTime)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.endTime = endTime;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public void setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public void setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public TimeZone getTimeZone() {
        if (this.cronEx != null) {
            return this.cronEx.getTimeZone();
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.cronEx != null) {
            this.cronEx.setTimeZone(timeZone);
        }
        this.timeZone = timeZone;
    }

    public void setCronExpression(String cronExpression) {
        this.setCronExpression(CronTrigger.determineCronExpression(cronExpression));
    }

    public void setCronExpression(CronExpression cronExpression) {
        TimeZone origTz = this.getTimeZone();
        this.cronEx = cronExpression;
        this.cronEx.setTimeZone(origTz);
    }

    public CronExpression getCronEx() {
        return this.cronEx;
    }

    public void setCronEx(CronExpression cronEx) {
        this.cronEx = cronEx;
    }

    public int getRepeatLimit() {
        return this.repeatLimit;
    }

    public void setRepeatLimit(int repeatLimit) {
        this.repeatLimit = repeatLimit;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public String[] getCalendarNames() {
        return this.calendarNames;
    }

    public void setCalendarNames(String[] calendarNames) {
        this.calendarNames = calendarNames;
    }

    public Calendars getCalendars() {
        return this.calendars;
    }

    public void setCalendars(Calendars calendars) {
        this.calendars = calendars;
    }

    public static CronExpression determineCronExpression(String cronExpression) {
        try {
            return new CronExpression(cronExpression);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse cron expression '" + cronExpression + "'", e);
        }
    }

    @Override
    public Date hasNextFireTime() {
        return this.nextFireTime;
    }

    @Override
    public synchronized Date nextFireTime() {
        if (this.nextFireTime == null) {
            return null;
        }
        Date date = new Date(this.nextFireTime.getTime() - 1000L);
        this.nextFireTime = this.getTimeAfter(this.nextFireTime);
        this.updateToNextIncludeDate();
        if (this.endTime != null && this.nextFireTime.after(this.endTime)) {
            this.nextFireTime = null;
        } else if (this.repeatLimit != -1 && this.repeatCount >= this.repeatLimit) {
            this.nextFireTime = null;
        }
        return date;
    }

    public void setFirstFireTimeAfter() {
        if (this.getStartTime().after(this.nextFireTime)) {
            this.nextFireTime = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && this.nextFireTime.compareTo(this.getEndTime()) >= 0) {
            this.nextFireTime = null;
        }
        Date pot = this.getTimeAfter(this.nextFireTime);
        this.nextFireTime = this.getEndTime() != null && pot != null && pot.after(this.getEndTime()) ? null : pot;
    }

    protected Date getTimeAfter(Date afterTime) {
        ++this.repeatCount;
        return this.cronEx == null ? null : this.cronEx.getTimeAfter(afterTime);
    }

    public void updateToNextIncludeDate() {
        if (this.calendars == null || this.calendarNames == null || this.calendarNames.length == 0) {
            return;
        }
        while (this.nextFireTime != null && (this.endTime == null || this.nextFireTime.before(this.endTime))) {
            boolean included = true;
            for (String calName : this.calendarNames) {
                Calendar cal = this.calendars.get(calName);
                if (cal == null || cal.isTimeIncluded(this.nextFireTime.getTime())) continue;
                included = false;
                break;
            }
            if (included) break;
            this.nextFireTime = this.getTimeAfter(this.nextFireTime);
        }
    }
}

