/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.patterns;

import java.util.UUID;
import org.drools.model.Condition;
import org.drools.model.GroupByPattern;
import org.drools.model.Pattern;
import org.drools.model.Variable;
import org.drools.model.functions.FunctionN;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.patterns.AccumulatePatternImpl;
import org.drools.model.patterns.PatternImpl;

public class GroupByPatternImpl<T, K>
extends AccumulatePatternImpl<T>
implements GroupByPattern<T, K> {
    private final String topic = UUID.randomUUID().toString();
    private final Variable[] vars;
    private final Variable<K> varKey;
    private final FunctionN groupingFunction;
    private final Pattern[] groupingPatterns;

    public GroupByPatternImpl(Condition condition, Variable[] vars, Variable<K> varKey, FunctionN groupingFunction, AccumulateFunction ... accumulateFunctions) {
        super(condition, accumulateFunctions);
        this.vars = vars;
        this.varKey = varKey;
        this.groupingFunction = groupingFunction;
        this.groupingPatterns = this.findGroupingPatterns(condition);
    }

    @Override
    public Condition.Type getType() {
        return Condition.Type.GROUP_BY;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Variable[] getVars() {
        return this.vars;
    }

    @Override
    public Variable<K> getVarKey() {
        return this.varKey;
    }

    @Override
    public FunctionN getGroupingFunction() {
        return this.groupingFunction;
    }

    @Override
    public Pattern[] getGroupingPatterns() {
        return this.groupingPatterns;
    }

    private Pattern[] findGroupingPatterns(Condition condition) {
        if (condition instanceof Pattern) {
            return new Pattern[]{(Pattern)condition};
        }
        Pattern[] patterns = new Pattern[this.vars.length];
        block0: for (int i = 0; i < this.vars.length; ++i) {
            for (Condition subCondition : condition.getSubConditions()) {
                PatternImpl patternImpl;
                if (!(subCondition instanceof PatternImpl) || (patternImpl = (PatternImpl)subCondition).getPatternVariable() != this.vars[i]) continue;
                patterns[i] = patternImpl;
                continue block0;
            }
        }
        return patterns;
    }
}

