/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.investment.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.examples.investment.domain.AssetClassAllocation;
import org.optaplanner.examples.investment.domain.InvestmentSolution;
import org.optaplanner.examples.investment.domain.Region;
import org.optaplanner.examples.investment.domain.Sector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvestmentIncrementalScoreCalculator
implements IncrementalScoreCalculator<InvestmentSolution, HardSoftLongScore> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private InvestmentSolution solution;
    private long squaredStandardDeviationFemtosMaximum;
    private long squaredStandardDeviationFemtos;
    private Map<Region, Long> regionQuantityTotalMap;
    private Map<Sector, Long> sectorQuantityTotalMap;
    private long hardScore;
    private long softScore;

    public void resetWorkingSolution(InvestmentSolution solution) {
        this.solution = solution;
        this.squaredStandardDeviationFemtosMaximum = solution.getParametrization().calculateSquaredStandardDeviationFemtosMaximum();
        this.squaredStandardDeviationFemtos = 0L;
        List<Region> regionList = solution.getRegionList();
        this.regionQuantityTotalMap = new HashMap<Region, Long>();
        for (Region region : regionList) {
            this.regionQuantityTotalMap.put(region, 0L);
        }
        List<Sector> sectorList = solution.getSectorList();
        this.sectorQuantityTotalMap = new HashMap<Sector, Long>(sectorList.size());
        for (Sector sector : sectorList) {
            this.sectorQuantityTotalMap.put(sector, 0L);
        }
        this.hardScore = 0L;
        this.softScore = 0L;
        for (AssetClassAllocation allocation : solution.getAssetClassAllocationList()) {
            this.insertQuantityMillis(allocation, true);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
        this.insertQuantityMillis((AssetClassAllocation)entity, false);
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        this.retractQuantityMillis((AssetClassAllocation)entity);
    }

    public void afterVariableChanged(Object entity, String variableName) {
        this.insertQuantityMillis((AssetClassAllocation)entity, false);
    }

    public void beforeEntityRemoved(Object entity) {
        this.retractQuantityMillis((AssetClassAllocation)entity);
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insertQuantityMillis(AssetClassAllocation allocation, boolean reset) {
        Long quantityMillis;
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore += this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        this.squaredStandardDeviationFemtos += this.calculateStandardDeviationSquaredFemtosDelta(allocation, reset);
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore -= this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        if ((quantityMillis = allocation.getQuantityMillis()) != null) {
            Region region = allocation.getRegion();
            long regionQuantityMaximum = region.getQuantityMillisMaximum();
            long oldRegionQuantity = this.regionQuantityTotalMap.get(region);
            long oldRegionAvailable = regionQuantityMaximum - oldRegionQuantity;
            long newRegionQuantity = oldRegionQuantity + quantityMillis;
            long newRegionAvailable = regionQuantityMaximum - newRegionQuantity;
            this.hardScore += Math.min(newRegionAvailable, 0L) - Math.min(oldRegionAvailable, 0L);
            this.regionQuantityTotalMap.put(region, newRegionQuantity);
            Sector sector = allocation.getSector();
            long sectorQuantityMaximum = sector.getQuantityMillisMaximum();
            long oldSectorQuantity = this.sectorQuantityTotalMap.get(sector);
            long oldSectorAvailable = sectorQuantityMaximum - oldSectorQuantity;
            long newSectorQuantity = oldSectorQuantity + quantityMillis;
            long newSectorAvailable = sectorQuantityMaximum - newSectorQuantity;
            this.hardScore += Math.min(newSectorAvailable, 0L) - Math.min(oldSectorAvailable, 0L);
            this.sectorQuantityTotalMap.put(sector, newSectorQuantity);
        }
        this.softScore += allocation.getQuantifiedExpectedReturnMicros();
    }

    private void retractQuantityMillis(AssetClassAllocation allocation) {
        Long quantityMillis;
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore += this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        this.squaredStandardDeviationFemtos -= this.calculateStandardDeviationSquaredFemtosDelta(allocation, false);
        if (this.squaredStandardDeviationFemtos > this.squaredStandardDeviationFemtosMaximum) {
            this.hardScore -= this.squaredStandardDeviationFemtos - this.squaredStandardDeviationFemtosMaximum;
        }
        if ((quantityMillis = allocation.getQuantityMillis()) != null) {
            Region region = allocation.getRegion();
            long regionQuantityMaximum = region.getQuantityMillisMaximum();
            long oldRegionQuantity = this.regionQuantityTotalMap.get(region);
            long oldRegionAvailable = regionQuantityMaximum - oldRegionQuantity;
            long newRegionQuantity = oldRegionQuantity - quantityMillis;
            long newRegionAvailable = regionQuantityMaximum - newRegionQuantity;
            this.hardScore += Math.min(newRegionAvailable, 0L) - Math.min(oldRegionAvailable, 0L);
            this.regionQuantityTotalMap.put(region, newRegionQuantity);
            Sector sector = allocation.getSector();
            long sectorQuantityMaximum = sector.getQuantityMillisMaximum();
            long oldSectorQuantity = this.sectorQuantityTotalMap.get(sector);
            long oldSectorAvailable = sectorQuantityMaximum - oldSectorQuantity;
            long newSectorQuantity = oldSectorQuantity - quantityMillis;
            long newSectorAvailable = sectorQuantityMaximum - newSectorQuantity;
            this.hardScore += Math.min(newSectorAvailable, 0L) - Math.min(oldSectorAvailable, 0L);
            this.sectorQuantityTotalMap.put(sector, newSectorQuantity);
        }
        this.softScore -= allocation.getQuantifiedExpectedReturnMicros();
    }

    private long calculateStandardDeviationSquaredFemtosDelta(AssetClassAllocation allocation, boolean reset) {
        long squaredFemtos = 0L;
        for (AssetClassAllocation other : this.solution.getAssetClassAllocationList()) {
            if (allocation == other) {
                long micros = allocation.getQuantifiedStandardDeviationRiskMicros();
                squaredFemtos += micros * micros * 1000L;
                continue;
            }
            long picos = allocation.getQuantifiedStandardDeviationRiskMicros() * other.getQuantifiedStandardDeviationRiskMicros();
            squaredFemtos += picos * allocation.getAssetClass().getCorrelationMillisMap().get(other.getAssetClass());
            if (reset) continue;
            squaredFemtos += picos * other.getAssetClass().getCorrelationMillisMap().get(allocation.getAssetClass());
        }
        return squaredFemtos;
    }

    public HardSoftLongScore calculateScore() {
        return HardSoftLongScore.of((long)this.hardScore, (long)this.softScore);
    }
}

