/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.composite;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.AbstractCountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.util.ValueRangeIterator;
import org.optaplanner.core.impl.solver.random.RandomUtils;

public class CompositeCountableValueRange<T>
extends AbstractCountableValueRange<T> {
    private final List<? extends CountableValueRange<T>> childValueRangeList;
    private final long size;

    public CompositeCountableValueRange(List<? extends CountableValueRange<T>> childValueRangeList) {
        this.childValueRangeList = childValueRangeList;
        long size = 0L;
        for (CountableValueRange<T> childValueRange : childValueRangeList) {
            size += childValueRange.getSize();
        }
        this.size = size;
    }

    public List<? extends ValueRange<T>> getChildValueRangeList() {
        return this.childValueRangeList;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public T get(long index) {
        long remainingIndex = index;
        for (CountableValueRange<T> childValueRange : this.childValueRangeList) {
            long childSize = childValueRange.getSize();
            if (remainingIndex < childSize) {
                return childValueRange.get(remainingIndex);
            }
            remainingIndex -= childSize;
        }
        throw new IndexOutOfBoundsException("The index (" + index + ") must be less than the size (" + this.size + ").");
    }

    @Override
    public boolean contains(T value) {
        for (CountableValueRange<T> childValueRange : this.childValueRangeList) {
            if (!childValueRange.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> createOriginalIterator() {
        ArrayList<Iterator<T>> iteratorList = new ArrayList<Iterator<T>>(this.childValueRangeList.size());
        for (CountableValueRange<T> childValueRange : this.childValueRangeList) {
            iteratorList.add(childValueRange.createOriginalIterator());
        }
        return Iterators.concat(iteratorList.iterator());
    }

    @Override
    public Iterator<T> createRandomIterator(Random workingRandom) {
        return new RandomCompositeValueRangeIterator(workingRandom);
    }

    private class RandomCompositeValueRangeIterator
    extends ValueRangeIterator<T> {
        private final Random workingRandom;

        public RandomCompositeValueRangeIterator(Random workingRandom) {
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            long index;
            long remainingIndex = index = RandomUtils.nextLong(this.workingRandom, CompositeCountableValueRange.this.size);
            for (CountableValueRange childValueRange : CompositeCountableValueRange.this.childValueRangeList) {
                long childSize = childValueRange.getSize();
                if (remainingIndex < childSize) {
                    return childValueRange.get(remainingIndex);
                }
                remainingIndex -= childSize;
            }
            throw new IllegalStateException("Impossible state because index (" + index + ") is always less than the size (" + CompositeCountableValueRange.this.size + ").");
        }
    }
}

