/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoft;

import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class HardMediumSoftScoreInliner
extends ScoreInliner<HardMediumSoftScore> {
    protected int hardScore;
    protected int mediumScore;
    protected int softScore;

    protected HardMediumSoftScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public IntWeightedScoreImpacter buildWeightedScoreImpacter(HardMediumSoftScore constraintWeight) {
        if (constraintWeight.equals(HardMediumSoftScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        int hardConstraintWeight = constraintWeight.getHardScore();
        int mediumConstraintWeight = constraintWeight.getMediumScore();
        int softConstraintWeight = constraintWeight.getSoftScore();
        if (mediumConstraintWeight == 0 && softConstraintWeight == 0) {
            return (matchWeight, matchScoreConsumer) -> {
                int hardImpact = hardConstraintWeight * matchWeight;
                this.hardScore += hardImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftScore.ofHard(hardImpact));
                }
                return () -> this.hardScore -= hardImpact;
            };
        }
        if (hardConstraintWeight == 0 && softConstraintWeight == 0) {
            return (matchWeight, matchScoreConsumer) -> {
                int mediumImpact = mediumConstraintWeight * matchWeight;
                this.mediumScore += mediumImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftScore.ofMedium(mediumImpact));
                }
                return () -> this.mediumScore -= mediumImpact;
            };
        }
        if (hardConstraintWeight == 0 && mediumConstraintWeight == 0) {
            return (matchWeight, matchScoreConsumer) -> {
                int softImpact = softConstraintWeight * matchWeight;
                this.softScore += softImpact;
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(HardMediumSoftScore.ofSoft(softImpact));
                }
                return () -> this.softScore -= softImpact;
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            int hardImpact = hardConstraintWeight * matchWeight;
            int mediumImpact = mediumConstraintWeight * matchWeight;
            int softImpact = softConstraintWeight * matchWeight;
            this.hardScore += hardImpact;
            this.mediumScore += mediumImpact;
            this.softScore += softImpact;
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(HardMediumSoftScore.of(hardImpact, mediumImpact, softImpact));
            }
            return () -> {
                this.hardScore -= hardImpact;
                this.mediumScore -= mediumImpact;
                this.softScore -= softImpact;
            };
        };
    }

    @Override
    public HardMediumSoftScore extractScore(int initScore) {
        return HardMediumSoftScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    public String toString() {
        return HardMediumSoftScore.class.getSimpleName() + " inliner";
    }
}

