/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.operation;

import java.lang.reflect.Method;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.ReflectionBeanPropertyMemberAccessor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.score.director.drools.testgen.fact.TestGenFact;
import org.optaplanner.core.impl.score.director.drools.testgen.operation.TestGenKieSessionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenKieSessionUpdate
implements TestGenKieSessionOperation {
    private static final Logger logger = LoggerFactory.getLogger(TestGenKieSessionUpdate.class);
    private final int id;
    private final TestGenFact entity;
    private final String variableName;
    private final ReflectionBeanPropertyMemberAccessor accessor;
    private final String setterName;
    private final TestGenFact value;

    public TestGenKieSessionUpdate(int id, TestGenFact entity, VariableDescriptor<?> variableDescriptor, TestGenFact value) {
        if (value == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        this.id = id;
        this.entity = entity;
        this.variableName = variableDescriptor.getVariableName();
        this.value = value;
        Method getter = ReflectionHelper.getGetterMethod(variableDescriptor.getEntityDescriptor().getEntityClass(), variableDescriptor.getVariableName());
        this.setterName = ReflectionHelper.getSetterMethod(getter.getDeclaringClass(), getter.getReturnType(), variableDescriptor.getVariableName()).getName();
        this.accessor = new ReflectionBeanPropertyMemberAccessor(getter);
    }

    public TestGenFact getValue() {
        return this.value;
    }

    @Override
    public void invoke(KieSession kieSession) {
        if (logger.isTraceEnabled()) {
            logger.trace("        [{}] {}.{}: {} \u2192 {}", new Object[]{this.id, this.entity.getInstance(), this.accessor.getName(), this.accessor.executeGetter(this.entity.getInstance()), this.value.getInstance()});
        }
        this.accessor.executeSetter(this.entity.getInstance(), this.value.getInstance());
        FactHandle fh = kieSession.getFactHandle(this.entity.getInstance());
        if (fh == null) {
            throw new IllegalStateException("No fact handle for " + this.entity);
        }
        kieSession.update(fh, this.entity.getInstance(), new String[]{this.variableName});
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append(String.format("        //%s\n", this));
        sb.append(String.format("        %s.%s(%s);\n", this.entity, this.setterName, this.value));
        sb.append(String.format("        kieSession.update(kieSession.getFactHandle(%s), %s, \"%s\");\n", this.entity, this.entity, this.variableName));
    }

    public String toString() {
        return "operation U #" + this.id;
    }
}

