/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.tri;

import java.math.BigDecimal;
import java.util.List;
import java.util.function.Consumer;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.IntWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.LongWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.core.impl.score.stream.bavet.tri.BavetScoringTriNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;

public final class BavetScoringTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C> {
    private final BavetAbstractTriConstraintStream<Solution_, A, B, C> parent;
    private final BavetConstraint<Solution_> constraint;
    private final boolean noMatchWeigher;
    private final ToIntTriFunction<A, B, C> intMatchWeigher;
    private final ToLongTriFunction<A, B, C> longMatchWeigher;
    private final TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher;

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint) {
        this(constraintFactory, parent, constraint, true, null, null, null);
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, ToIntTriFunction<A, B, C> intMatchWeigher) {
        this(constraintFactory, parent, constraint, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, ToLongTriFunction<A, B, C> longMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, constraint, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, BavetConstraint<Solution_> constraint, boolean noMatchWeigher, ToIntTriFunction<A, B, C> intMatchWeigher, ToLongTriFunction<A, B, C> longMatchWeigher, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory);
        this.parent = parent;
        this.constraint = constraint;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected BavetScoringTriNode<A, B, C> createNode(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractTriNode<A, B, C> parentNode) {
        QuadFunction<Object, Object, Object, Consumer, UndoScoreImpacter> scoreImpacter;
        ScoreInliner<?> scoreInliner = buildPolicy.getSession().getScoreInliner();
        WeightedScoreImpacter weightedScoreImpacter = scoreInliner.buildWeightedScoreImpacter(constraintWeight);
        if (weightedScoreImpacter instanceof IntWeightedScoreImpacter) {
            IntWeightedScoreImpacter intWeightedScoreImpacter = (IntWeightedScoreImpacter)weightedScoreImpacter;
            if (this.intMatchWeigher != null) {
                scoreImpacter = (a, b, c, matchScoreConsumer) -> {
                    int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return intWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + TriConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return an int.");
                scoreImpacter = (a, b, c, matchScoreConsumer) -> intWeightedScoreImpacter.impactScore(1, (Consumer<Score<?>>)matchScoreConsumer);
            }
        } else if (weightedScoreImpacter instanceof LongWeightedScoreImpacter) {
            LongWeightedScoreImpacter longWeightedScoreImpacter = (LongWeightedScoreImpacter)weightedScoreImpacter;
            if (this.longMatchWeigher != null) {
                scoreImpacter = (a, b, c, matchScoreConsumer) -> {
                    long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return longWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + TriConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return a long.");
                scoreImpacter = (a, b, c, matchScoreConsumer) -> longWeightedScoreImpacter.impactScore(1L, (Consumer<Score<?>>)matchScoreConsumer);
            }
        } else {
            if (!(weightedScoreImpacter instanceof BigDecimalWeightedScoreImpacter)) throw new IllegalStateException("Unsupported weightedScoreImpacter (" + weightedScoreImpacter + ").");
            BigDecimalWeightedScoreImpacter bigDecimalWeightedScoreImpacter = (BigDecimalWeightedScoreImpacter)weightedScoreImpacter;
            if (this.bigDecimalMatchWeigher != null) {
                scoreImpacter = (a, b, c, matchScoreConsumer) -> {
                    BigDecimal matchWeight = this.bigDecimalMatchWeigher.apply(a, b, c);
                    this.constraint.assertCorrectImpact(matchWeight);
                    return bigDecimalWeightedScoreImpacter.impactScore(matchWeight, (Consumer<Score<?>>)matchScoreConsumer);
                };
            } else {
                if (!this.noMatchWeigher) throw new IllegalStateException("The matchWeigher of " + TriConstraintStream.class.getSimpleName() + ".penalize(matchWeigher) of the constraint (" + this.constraint.getConstraintId() + ") must return a " + BigDecimal.class.getSimpleName() + ".");
                scoreImpacter = (a, b, c, matchScoreConsumer) -> bigDecimalWeightedScoreImpacter.impactScore(BigDecimal.ONE, (Consumer<Score<?>>)matchScoreConsumer);
            }
        }
        BavetScoringTriNode<Object, Object, Object> bavetScoringTriNode = new BavetScoringTriNode<Object, Object, Object>(buildPolicy.getSession(), nodeOrder, this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), constraintWeight, scoreImpacter);
        buildPolicy.addScoringNode(bavetScoringTriNode);
        return bavetScoringTriNode;
    }

    @Override
    protected void createChildNodeChains(BavetNodeBuildPolicy<Solution_> buildPolicy, Score<?> constraintWeight, int nodeOrder, BavetAbstractTriNode<A, B, C> node) {
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
    }

    public String toString() {
        return "Scoring()";
    }
}

