/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.util.List;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsAbstractBiConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsExistsBiConstraintStream<Solution_, A, B>
extends DroolsAbstractBiConstraintStream<Solution_, A, B> {
    private final DroolsAbstractConstraintStream<Solution_> parent;
    private final DroolsBiCondition<A, B, ?> condition;
    private final String streamName;

    public <C> DroolsExistsBiConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, DroolsAbstractBiConstraintStream<Solution_, A, B> parent, boolean shouldExist, Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        super(constraintFactory);
        this.parent = parent;
        this.streamName = shouldExist ? "BiIfExists()" : "BiIfNotExists()";
        this.condition = shouldExist ? parent.getCondition().andIfExists(otherClass, joiners) : parent.getCondition().andIfNotExists(otherClass, joiners);
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return this.parent.getFromStreamList();
    }

    @Override
    protected DroolsAbstractConstraintStream<Solution_> getParent() {
        return this.parent;
    }

    @Override
    public DroolsBiCondition<A, B, ?> getCondition() {
        return this.condition;
    }

    public String toString() {
        return this.streamName + " with " + this.getChildStreams().size() + " children";
    }
}

