/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.functions;

import java.io.Serializable;
import org.drools.model.functions.IntrospectableLambda;
import org.drools.model.functions.PredicateInformation;

public interface Predicate2<A, B>
extends Serializable {
    public boolean test(A var1, B var2) throws Exception;

    default public Predicate2<A, B> negate() {
        return (a, b) -> !this.test(a, b);
    }

    default public PredicateInformation predicateInformation() {
        return PredicateInformation.EMPTY_PREDICATE_INFORMATION;
    }

    public static class Impl<A, B>
    extends IntrospectableLambda
    implements Predicate2<A, B> {
        private final Predicate2<A, B> predicate;

        public Impl(Predicate2<A, B> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(A a, B b) throws Exception {
            return this.predicate.test(a, b);
        }

        @Override
        public Object getLambda() {
            return this.predicate;
        }

        @Override
        public PredicateInformation predicateInformation() {
            return this.predicate.predicateInformation();
        }
    }
}

