/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.curriculumcourse.optional.score;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.curriculumcourse.domain.Lecture;
import org.optaplanner.examples.curriculumcourse.domain.UnavailablePeriodPenalty;
import org.optaplanner.examples.curriculumcourse.domain.solver.CourseConflict;

public class CourseScheduleConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory factory) {
        return new Constraint[]{this.conflictingLecturesDifferentCourseInSamePeriod(factory), this.conflictingLecturesSameCourseInSamePeriod(factory), this.roomOccupancy(factory), this.unavailablePeriodPenalty(factory), this.roomCapacity(factory), this.minimumWorkingDays(factory), this.curriculumCompactness(factory), this.roomStability(factory)};
    }

    private Constraint teacherConflict(ConstraintFactory factory) {
        return factory.from(Lecture.class).join(Lecture.class, Joiners.equal(Lecture::getTeacher), Joiners.equal(Lecture::getPeriod), Joiners.lessThan(AbstractPersistable::getId)).penalize("teacherConflict", (Score)HardSoftScore.ofHard((int)1));
    }

    private Constraint curriculumConflict(ConstraintFactory factory) {
        return factory.from(Lecture.class).join(Lecture.class, Joiners.equal(Lecture::getPeriod), Joiners.lessThan(AbstractPersistable::getId)).filter((lecture1, lecture2) -> lecture1.getCurriculumList().stream().anyMatch(lecture -> lecture2.getCurriculumList().contains(lecture))).penalize("curriculumConflict", (Score)HardSoftScore.ofHard((int)1), (lecture1, lecture2) -> (int)lecture1.getCurriculumList().stream().filter(lecture -> lecture2.getCurriculumList().contains(lecture)).count());
    }

    private Constraint conflictingLecturesDifferentCourseInSamePeriod(ConstraintFactory factory) {
        return factory.from(CourseConflict.class).join(Lecture.class, Joiners.equal(CourseConflict::getLeftCourse, Lecture::getCourse)).join(Lecture.class, Joiners.equal((courseConflict, lecture1) -> courseConflict.getRightCourse(), Lecture::getCourse), Joiners.equal((courseConflict, lecture1) -> lecture1.getPeriod(), Lecture::getPeriod)).filter((courseConflict, lecture1, lecture2) -> lecture1 != lecture2).penalize("conflictingLecturesDifferentCourseInSamePeriod", (Score)HardSoftScore.ofHard((int)1), (courseConflict, lecture1, lecture2) -> courseConflict.getConflictCount());
    }

    private Constraint conflictingLecturesSameCourseInSamePeriod(ConstraintFactory factory) {
        return factory.from(Lecture.class).join(Lecture.class, Joiners.equal(Lecture::getCourse, Lecture::getCourse), Joiners.equal(Lecture::getPeriod, Lecture::getPeriod), Joiners.lessThan(AbstractPersistable::getId, AbstractPersistable::getId)).penalize("conflictingLecturesSameCourseInSamePeriod", (Score)HardSoftScore.ofHard((int)1), (lecture1, lecture2) -> 1 + lecture1.getCurriculumList().size());
    }

    private Constraint roomOccupancy(ConstraintFactory factory) {
        throw new UnsupportedOperationException("Not yet implemented due to missing support for tri-grouping.");
    }

    private Constraint unavailablePeriodPenalty(ConstraintFactory factory) {
        return factory.from(UnavailablePeriodPenalty.class).join(Lecture.class, Joiners.equal(UnavailablePeriodPenalty::getCourse, Lecture::getCourse), Joiners.equal(UnavailablePeriodPenalty::getPeriod, Lecture::getPeriod)).penalize("unavailablePeriodPenalty", (Score)HardSoftScore.ofHard((int)10));
    }

    private Constraint roomCapacity(ConstraintFactory factory) {
        return factory.from(Lecture.class).filter(lecture -> lecture.getStudentSize() > lecture.getRoom().getCapacity()).penalize("roomCapacity", (Score)HardSoftScore.ofSoft((int)1), lecture -> lecture.getStudentSize() - lecture.getRoom().getCapacity());
    }

    private Constraint minimumWorkingDays(ConstraintFactory factory) {
        return factory.from(Lecture.class).groupBy(Lecture::getCourse, ConstraintCollectors.countDistinct(Lecture::getDay)).filter((course, dayCount) -> course.getMinWorkingDaySize() > dayCount).penalize("minimumWorkingDays", (Score)HardSoftScore.ofSoft((int)5), (course, dayCount) -> course.getMinWorkingDaySize() - dayCount);
    }

    private Constraint curriculumCompactness(ConstraintFactory factory) {
        throw new UnsupportedOperationException("Not yet implemented due to missing support for bi-grouping.");
    }

    private Constraint roomStability(ConstraintFactory factory) {
        return factory.from(Lecture.class).groupBy(Lecture::getCourse, ConstraintCollectors.countDistinct(Lecture::getRoom)).filter((course, roomCount) -> roomCount > 1).penalize("roomStability", (Score)HardSoftScore.ofSoft((int)1), (course, roomCount) -> roomCount - 1);
    }
}

