/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.common.accessor;

import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.optaplanner.core.impl.domain.common.ReflectionHelper;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessorFactory;

public final class LambdaBeanPropertyMemberAccessor
implements MemberAccessor {
    private final Class<?> propertyType;
    private final String propertyName;
    private final Method getterMethod;
    private final Function getterFunction;
    private final Method setterMethod;
    private final BiConsumer setterFunction;

    public LambdaBeanPropertyMemberAccessor(Method getterMethod) {
        this(getterMethod, false);
    }

    public LambdaBeanPropertyMemberAccessor(Method getterMethod, boolean getterOnly) {
        this.getterMethod = getterMethod;
        Class<?> declaringClass = getterMethod.getDeclaringClass();
        if (!ReflectionHelper.isGetterMethod(getterMethod)) {
            throw new IllegalArgumentException("The getterMethod (" + getterMethod + ") is not a valid getter.");
        }
        this.propertyType = getterMethod.getReturnType();
        this.propertyName = ReflectionHelper.getGetterPropertyName(getterMethod);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        this.getterFunction = this.createGetterFunction(lookup);
        if (getterOnly) {
            this.setterMethod = null;
            this.setterFunction = null;
        } else {
            this.setterMethod = ReflectionHelper.getSetterMethod(declaringClass, getterMethod.getReturnType(), this.propertyName);
            this.setterFunction = this.createSetterFunction(lookup);
        }
    }

    private Function createGetterFunction(MethodHandles.Lookup lookup) {
        CallSite getterSite;
        Class<?> declaringClass = this.getterMethod.getDeclaringClass();
        try {
            getterSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), lookup.findVirtual(declaringClass, this.getterMethod.getName(), MethodType.methodType(this.propertyType)), MethodType.methodType(this.propertyType, declaringClass));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Lambda creation failed for getterMethod (" + this.getterMethod + ").\n" + MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE, e);
        }
        catch (NoSuchMethodException | LambdaConversionException e) {
            throw new IllegalArgumentException("Lambda creation failed for getterMethod (" + this.getterMethod + ").", e);
        }
        try {
            return getterSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Lambda creation failed for getterMethod (" + this.getterMethod + ").", e);
        }
    }

    private BiConsumer createSetterFunction(MethodHandles.Lookup lookup) {
        CallSite setterSite;
        if (this.setterMethod == null) {
            return null;
        }
        Class<?> declaringClass = this.setterMethod.getDeclaringClass();
        try {
            setterSite = LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(BiConsumer.class), MethodType.methodType(Void.TYPE, Object.class, Object.class), lookup.findVirtual(declaringClass, this.setterMethod.getName(), MethodType.methodType(Void.TYPE, this.propertyType)), MethodType.methodType(Void.TYPE, declaringClass, this.propertyType));
        }
        catch (IllegalAccessException | NoSuchMethodException | LambdaConversionException e) {
            throw new IllegalArgumentException("Lambda creation failed for setterMethod (" + this.setterMethod + ").", e);
        }
        try {
            return setterSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Lambda creation failed for setterMethod (" + this.setterMethod + ").", e);
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.getterMethod.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.propertyName;
    }

    @Override
    public Class<?> getType() {
        return this.propertyType;
    }

    @Override
    public Type getGenericType() {
        return this.getterMethod.getGenericReturnType();
    }

    @Override
    public Object executeGetter(Object bean) {
        return this.getterFunction.apply(bean);
    }

    @Override
    public boolean supportSetter() {
        return this.setterMethod != null;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        this.setterFunction.accept(bean, value);
    }

    @Override
    public String getSpeedNote() {
        return "pretty fast access with LambdaMetafactory";
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getterMethod.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getterMethod.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getterMethod.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getterMethod.getDeclaredAnnotations();
    }

    public String toString() {
        return "bean property " + this.propertyName + " on " + this.getterMethod.getDeclaringClass();
    }
}

