/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class BendableBigDecimalScoreInliner
extends ScoreInliner<BendableBigDecimalScore> {
    private BigDecimal[] hardScores;
    private BigDecimal[] softScores;

    public BendableBigDecimalScoreInliner(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled);
        this.hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(this.hardScores, BigDecimal.ZERO);
        this.softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(this.softScores, BigDecimal.ZERO);
    }

    public BigDecimalWeightedScoreImpacter buildWeightedScoreImpacter(BendableBigDecimalScore constraintWeight) {
        if (constraintWeight.equals(BendableBigDecimalScore.zero(this.hardScores.length, this.softScores.length))) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        Integer singleLevel = null;
        for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
            if (constraintWeight.getHardOrSoftScore(i).equals(BigDecimal.ZERO)) continue;
            if (singleLevel != null) {
                singleLevel = null;
                break;
            }
            singleLevel = i;
        }
        if (singleLevel != null) {
            BigDecimal levelWeight = constraintWeight.getHardOrSoftScore(singleLevel);
            if (singleLevel < constraintWeight.getHardLevelsSize()) {
                int level = singleLevel;
                return (matchWeight, matchScoreConsumer) -> {
                    BigDecimal hardImpact = levelWeight.multiply(matchWeight);
                    this.hardScores[level] = this.hardScores[level].add(hardImpact);
                    if (this.constraintMatchEnabled) {
                        matchScoreConsumer.accept(BendableBigDecimalScore.ofHard(this.hardScores.length, this.softScores.length, level, hardImpact));
                    }
                    return () -> {
                        this.hardScores[level] = this.hardScores[level].subtract(hardImpact);
                    };
                };
            }
            int level = singleLevel - constraintWeight.getHardLevelsSize();
            return (matchWeight, matchScoreConsumer) -> {
                BigDecimal softImpact = levelWeight.multiply(matchWeight);
                this.softScores[level] = this.softScores[level].add(softImpact);
                if (this.constraintMatchEnabled) {
                    matchScoreConsumer.accept(BendableBigDecimalScore.ofSoft(this.hardScores.length, this.softScores.length, level, softImpact));
                }
                return () -> {
                    this.softScores[level] = this.softScores[level].subtract(softImpact);
                };
            };
        }
        return (matchWeight, matchScoreConsumer) -> {
            int i;
            BigDecimal[] hardImpacts = new BigDecimal[this.hardScores.length];
            BigDecimal[] softImpacts = new BigDecimal[this.softScores.length];
            for (i = 0; i < hardImpacts.length; ++i) {
                hardImpacts[i] = constraintWeight.getHardScore(i).multiply(matchWeight);
                this.hardScores[i] = this.hardScores[i].add(hardImpacts[i]);
            }
            for (i = 0; i < softImpacts.length; ++i) {
                softImpacts[i] = constraintWeight.getSoftScore(i).multiply(matchWeight);
                this.softScores[i] = this.softScores[i].add(softImpacts[i]);
            }
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(BendableBigDecimalScore.of(hardImpacts, softImpacts));
            }
            return () -> {
                int i;
                for (i = 0; i < hardImpacts.length; ++i) {
                    this.hardScores[i] = this.hardScores[i].subtract(hardImpacts[i]);
                }
                for (i = 0; i < softImpacts.length; ++i) {
                    this.softScores[i] = this.softScores[i].subtract(softImpacts[i]);
                }
            };
        };
    }

    @Override
    public BendableBigDecimalScore extractScore(int initScore) {
        return BendableBigDecimalScore.ofUninitialized(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }

    public String toString() {
        return BendableBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

