/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import java.io.File;
import org.optaplanner.core.config.solver.SolverConfig;

public final class XStreamConfigReader {
    public static XStream buildXStream() {
        XStream xStream = new XStream();
        xStream.setMode(1002);
        xStream.aliasSystemAttribute("xStreamId", "id");
        xStream.aliasSystemAttribute("xStreamRef", "reference");
        xStream.processAnnotations(SolverConfig.class);
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByRegExp(new String[]{"org\\.optaplanner\\.\\w+\\.config\\..*"});
        return xStream;
    }

    public static XStream buildXStream(ClassLoader classLoader) {
        XStream xStream = XStreamConfigReader.buildXStream();
        if (classLoader != null) {
            xStream.setClassLoader(classLoader);
        }
        return xStream;
    }

    public static XStream buildXStream(ClassLoader classLoader, Class ... xStreamAnnotations) {
        XStream xStream = XStreamConfigReader.buildXStream(classLoader);
        if (xStreamAnnotations.length > 0) {
            xStream.processAnnotations(xStreamAnnotations);
            xStream.allowTypes(xStreamAnnotations);
        }
        return xStream;
    }

    public static XStream buildXStreamPortable(ClassLoader classLoader, Class ... xStreamAnnotations) {
        XStream xStream = XStreamConfigReader.buildXStream(classLoader, xStreamAnnotations);
        xStream.registerConverter((SingleValueConverter)new FileConverter(){

            public String toString(Object obj) {
                String path = ((File)obj).getPath();
                return path == null ? null : path.replace('\\', '/');
            }
        });
        return xStream;
    }

    private XStreamConfigReader() {
    }
}

