/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.anchor;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.anchor.AnchorVariableSupply;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;

public class ExternalizedAnchorVariableSupply<Solution_>
implements SourcedVariableListener<Solution_, Object>,
AnchorVariableSupply {
    protected final VariableDescriptor<Solution_> previousVariableDescriptor;
    protected final SingletonInverseVariableSupply nextVariableSupply;
    protected Map<Object, Object> anchorMap = null;

    public ExternalizedAnchorVariableSupply(VariableDescriptor<Solution_> previousVariableDescriptor, SingletonInverseVariableSupply nextVariableSupply) {
        this.previousVariableDescriptor = previousVariableDescriptor;
        this.nextVariableSupply = nextVariableSupply;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.previousVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(ScoreDirector<Solution_> scoreDirector) {
        EntityDescriptor<Solution_> entityDescriptor = this.previousVariableDescriptor.getEntityDescriptor();
        List<Object> entityList = entityDescriptor.extractEntities(scoreDirector.getWorkingSolution());
        this.anchorMap = new IdentityHashMap<Object, Object>(entityList.size());
        for (Object entity : entityList) {
            this.insert(scoreDirector, entity);
        }
    }

    @Override
    public void close() {
        this.anchorMap = null;
    }

    @Override
    public void beforeEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterEntityAdded(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    @Override
    public void afterVariableChanged(ScoreDirector<Solution_> scoreDirector, Object entity) {
        this.insert(scoreDirector, entity);
    }

    @Override
    public void beforeEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
        boolean removeSucceeded;
        boolean bl = removeSucceeded = this.anchorMap.remove(entity) != null;
        if (!removeSucceeded) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.previousVariableDescriptor.getVariableName() + ") cannot be retracted: it was never inserted.");
        }
    }

    @Override
    public void afterEntityRemoved(ScoreDirector<Solution_> scoreDirector, Object entity) {
    }

    protected void insert(ScoreDirector<Solution_> scoreDirector, Object entity) {
        Object previousEntity = this.previousVariableDescriptor.getValue(entity);
        Object anchor = previousEntity == null ? null : (this.previousVariableDescriptor.isValuePotentialAnchor(previousEntity) ? previousEntity : this.anchorMap.get(previousEntity));
        Object nextEntity = entity;
        while (nextEntity != null && this.anchorMap.get(nextEntity) != anchor) {
            this.anchorMap.put(nextEntity, anchor);
            nextEntity = this.nextVariableSupply.getInverseSingleton(nextEntity);
        }
    }

    @Override
    public Object getAnchor(Object entity) {
        return this.anchorMap.get(entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.previousVariableDescriptor.getVariableName() + ")";
    }
}

