/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.score.constraint.ConstraintMatch;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;

public final class DefaultScoreExplanation<Solution_, Score_ extends Score<Score_>>
implements ScoreExplanation<Solution_, Score_> {
    private static final int DEFAULT_SCORE_EXPLANATION_INDICTMENT_LIMIT = 5;
    private static final int DEFAULT_SCORE_EXPLANATION_CONSTRAINT_MATCH_LIMIT = 2;
    private final Solution_ solution;
    private final Score_ score;
    private final Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap;
    private final Map<Object, Indictment<Score_>> indictmentMap;
    private final AtomicReference<String> summary = new AtomicReference();

    public static <Score_ extends Score<Score_>> String explainScore(Score_ workingScore, Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection, Collection<Indictment<Score_>> indictmentCollection) {
        return DefaultScoreExplanation.explainScore(workingScore, constraintMatchTotalCollection, indictmentCollection, 5, 2);
    }

    public static <Score_ extends Score<Score_>> String explainScore(Score_ workingScore, Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection, Collection<Indictment<Score_>> indictmentCollection, int indictmentLimit, int constraintMatchLimit) {
        StringBuilder scoreExplanation = new StringBuilder((constraintMatchTotalCollection.size() + 4 + 2 * indictmentLimit) * 80);
        scoreExplanation.append("Explanation of score (").append(workingScore).append("):\n");
        scoreExplanation.append("    Constraint match totals:\n");
        Comparator<ConstraintMatchTotal> constraintMatchTotalComparator = Comparator.comparing(ConstraintMatchTotal::getScore);
        Comparator<ConstraintMatch> constraintMatchComparator = Comparator.comparing(ConstraintMatch::getScore);
        constraintMatchTotalCollection.stream().sorted(constraintMatchTotalComparator).forEach(constraintMatchTotal -> {
            Set constraintMatchSet = constraintMatchTotal.getConstraintMatchSet();
            scoreExplanation.append("        ").append(constraintMatchTotal.getScore().toShortString()).append(": constraint (").append(constraintMatchTotal.getConstraintName()).append(") has ").append(constraintMatchSet.size()).append(" matches:\n");
            constraintMatchSet.stream().sorted(constraintMatchComparator).limit(constraintMatchLimit).forEach(constraintMatch -> scoreExplanation.append("            ").append(constraintMatch.getScore().toShortString()).append(": justifications (").append(constraintMatch.getJustificationList()).append(")\n"));
            if (constraintMatchSet.size() > constraintMatchLimit) {
                scoreExplanation.append("            ...\n");
            }
        });
        int indictmentCount = indictmentCollection.size();
        if (indictmentLimit < indictmentCount) {
            scoreExplanation.append("    Indictments (top ").append(indictmentLimit).append(" of ").append(indictmentCount).append("):\n");
        } else {
            scoreExplanation.append("    Indictments:\n");
        }
        Comparator<Indictment> indictmentComparator = Comparator.comparing(Indictment::getScore);
        Comparator<ConstraintMatch> constraintMatchScoreComparator = Comparator.comparing(ConstraintMatch::getScore);
        indictmentCollection.stream().sorted(indictmentComparator).limit(indictmentLimit).forEach(indictment -> {
            Set constraintMatchSet = indictment.getConstraintMatchSet();
            scoreExplanation.append("        ").append(indictment.getScore().toShortString()).append(": justification (").append(indictment.getJustification()).append(") has ").append(constraintMatchSet.size()).append(" matches:\n");
            constraintMatchSet.stream().sorted(constraintMatchScoreComparator).limit(constraintMatchLimit).forEach(constraintMatch -> scoreExplanation.append("            ").append(constraintMatch.getScore().toShortString()).append(": constraint (").append(constraintMatch.getConstraintName()).append(")\n"));
            if (constraintMatchSet.size() > constraintMatchLimit) {
                scoreExplanation.append("            ...\n");
            }
        });
        if (indictmentCount > indictmentLimit) {
            scoreExplanation.append("        ...\n");
        }
        return scoreExplanation.toString();
    }

    public DefaultScoreExplanation(Solution_ solution, Score_ score, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.solution = solution;
        this.score = (Score)Objects.requireNonNull(score);
        this.constraintMatchTotalMap = Objects.requireNonNull(constraintMatchTotalMap);
        this.indictmentMap = Objects.requireNonNull(indictmentMap);
    }

    @Override
    public Solution_ getSolution() {
        return this.solution;
    }

    @Override
    public Score_ getScore() {
        return this.score;
    }

    @Override
    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.constraintMatchTotalMap;
    }

    @Override
    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.indictmentMap;
    }

    @Override
    public String getSummary() {
        return this.summary.updateAndGet(currentSummary -> {
            if (currentSummary != null) {
                return currentSummary;
            }
            return DefaultScoreExplanation.explainScore(this.score, this.constraintMatchTotalMap.values(), this.indictmentMap.values());
        });
    }

    public String toString() {
        return this.getSummary();
    }
}

