/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoftbigdecimal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.inliner.UndoScoreImpacter;
import org.optaplanner.core.impl.score.inliner.WeightedScoreImpacter;

public final class HardSoftBigDecimalScoreInliner
extends ScoreInliner<HardSoftBigDecimalScore> {
    private BigDecimal hardScore = BigDecimal.ZERO;
    private BigDecimal softScore = BigDecimal.ZERO;

    protected HardSoftBigDecimalScoreInliner(Map<Constraint, HardSoftBigDecimalScore> constraintToWeightMap, boolean constraintMatchEnabled) {
        super(constraintToWeightMap, constraintMatchEnabled, HardSoftBigDecimalScore.ZERO);
    }

    @Override
    public WeightedScoreImpacter buildWeightedScoreImpacter(Constraint constraint) {
        HardSoftBigDecimalScore constraintWeight = (HardSoftBigDecimalScore)this.getConstraintWeight(constraint);
        BigDecimal hardConstraintWeight = constraintWeight.getHardScore();
        BigDecimal softConstraintWeight = constraintWeight.getSoftScore();
        if (softConstraintWeight.equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
                this.hardScore = this.hardScore.add(hardImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.hardScore = this.hardScore.subtract(hardImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftBigDecimalScore.ofHard(hardImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        if (hardConstraintWeight.equals(BigDecimal.ZERO)) {
            return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
                BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
                this.softScore = this.softScore.add(softImpact);
                UndoScoreImpacter undoScoreImpact = () -> {
                    this.softScore = this.softScore.subtract(softImpact);
                };
                if (!this.constraintMatchEnabled) {
                    return undoScoreImpact;
                }
                Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftBigDecimalScore.ofSoft(softImpact), (List)justificationsSupplier.get());
                return () -> {
                    undoScoreImpact.run();
                    undoConstraintMatch.run();
                };
            });
        }
        return WeightedScoreImpacter.of((matchWeight, justificationsSupplier) -> {
            BigDecimal hardImpact = hardConstraintWeight.multiply(matchWeight);
            BigDecimal softImpact = softConstraintWeight.multiply(matchWeight);
            this.hardScore = this.hardScore.add(hardImpact);
            this.softScore = this.softScore.add(softImpact);
            UndoScoreImpacter undoScoreImpact = () -> {
                this.hardScore = this.hardScore.subtract(hardImpact);
                this.softScore = this.softScore.subtract(softImpact);
            };
            if (!this.constraintMatchEnabled) {
                return undoScoreImpact;
            }
            Runnable undoConstraintMatch = this.addConstraintMatch(constraint, constraintWeight, HardSoftBigDecimalScore.of(hardImpact, softImpact), (List)justificationsSupplier.get());
            return () -> {
                undoScoreImpact.run();
                undoConstraintMatch.run();
            };
        });
    }

    @Override
    public HardSoftBigDecimalScore extractScore(int initScore) {
        return HardSoftBigDecimalScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

