/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director.drools.testgen.mutation;

import java.util.List;

public class TestGenHeadCuttingMutator<T> {
    private final List<T> list;
    private double cutFactor = 0.8;
    private int totalCutSize = 0;
    private int revertIncrement = -1;
    private int cutIncrement;

    public TestGenHeadCuttingMutator(List<T> list) {
        this.list = list;
        this.updateIncrement(false);
    }

    public boolean canMutate() {
        return this.cutIncrement > 0 && this.totalCutSize + this.cutIncrement <= this.list.size();
    }

    public List<T> mutate() {
        this.totalCutSize += this.cutIncrement;
        this.revertIncrement = this.cutIncrement;
        this.updateIncrement(false);
        return this.getResult();
    }

    public void revert() {
        if (this.revertIncrement < 0) {
            throw new IllegalStateException("Can't revert without performing mutation first");
        }
        this.totalCutSize -= this.revertIncrement;
        this.revertIncrement = -1;
        this.cutFactor /= 2.0;
        this.updateIncrement(true);
    }

    private void updateIncrement(boolean revert) {
        this.cutIncrement = (int)((double)(this.list.size() - this.totalCutSize) * this.cutFactor);
        if (this.cutIncrement == 0 && !revert) {
            this.cutIncrement = 1;
        }
    }

    public List<T> getResult() {
        return this.list.subList(this.totalCutSize, this.list.size());
    }
}

