/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.uni;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintSession;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetAbstractTuple;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetJoinBridgeNode;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetTupleState;
import org.optaplanner.core.impl.score.stream.bavet.common.index.BavetIndex;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetJoinBridgeUniTuple;

public final class BavetJoinBridgeUniNode<A>
extends BavetAbstractUniNode<A>
implements BavetJoinBridgeNode {
    private final BavetAbstractUniNode<A> parentNode;
    private final Function<A, Object[]> mapping;
    private Consumer<BavetJoinBridgeUniTuple<A>> childTupleRefresher;
    private final BavetIndex<BavetJoinBridgeUniTuple<A>> index;

    public BavetJoinBridgeUniNode(BavetConstraintSession session, int nodeIndex, BavetAbstractUniNode<A> parentNode, Function<A, Object[]> mapping, BavetIndex<BavetJoinBridgeUniTuple<A>> index) {
        super(session, nodeIndex);
        this.parentNode = parentNode;
        this.mapping = mapping;
        this.index = index;
    }

    @Override
    public List<BavetAbstractUniNode<A>> getChildNodeList() {
        return Collections.emptyList();
    }

    @Override
    public BavetJoinBridgeUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        return new BavetJoinBridgeUniTuple<A>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetJoinBridgeUniTuple tuple = (BavetJoinBridgeUniTuple)uncastTuple;
        Object a = tuple.getFactA();
        if (tuple.getState() != BavetTupleState.CREATING) {
            this.index.remove(tuple);
        }
        if (tuple.isActive()) {
            Object[] indexProperties = this.mapping.apply(a);
            this.index.put(indexProperties, tuple);
        }
        this.childTupleRefresher.accept(tuple);
    }

    public String toString() {
        return "JoinBridge()";
    }

    public BavetIndex<BavetJoinBridgeUniTuple<A>> getIndex() {
        return this.index;
    }

    public void setChildTupleRefresher(Consumer<BavetJoinBridgeUniTuple<A>> childTupleRefresher) {
        this.childTupleRefresher = childTupleRefresher;
    }
}

