/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Objects;
import java.util.function.BiFunction;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Tuple;
import org.drools.model.Variable;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.AbstractAccumulator;

final class UniAccumulator<A, ResultContainer_, Result_>
extends AbstractAccumulator<ResultContainer_, Result_> {
    private final String varA;
    private final BiFunction<ResultContainer_, A, Runnable> accumulator;
    private boolean subnetwork;
    private Declaration declaration;
    private int offset;

    public UniAccumulator(Variable<A> varA, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        super(collector.supplier(), collector.finisher());
        this.varA = varA.getName();
        this.accumulator = Objects.requireNonNull(collector.accumulator());
    }

    public Object accumulate(Object workingMemoryContext, Object context, Tuple leftTuple, InternalFactHandle handle, Declaration[] declarations, Declaration[] innerDeclarations, WorkingMemory workingMemory) {
        InternalFactHandle factHandle = this.getFactHandle(leftTuple, handle, innerDeclarations);
        Object a = this.declaration.getValue(null, factHandle.getObject());
        return this.accumulator.apply(context, a);
    }

    private InternalFactHandle getFactHandle(Tuple leftTuple, InternalFactHandle handle, Declaration[] innerDeclarations) {
        if (this.declaration == null) {
            return this.init(leftTuple, handle, innerDeclarations);
        }
        if (!this.subnetwork) {
            return handle;
        }
        return UniAccumulator.getTuple(this.offset, leftTuple).getFactHandle();
    }

    private InternalFactHandle init(Tuple leftTuple, InternalFactHandle handle, Declaration[] innerDeclarations) {
        for (Declaration declaration : innerDeclarations) {
            if (!declaration.getBindingName().equals(this.varA)) continue;
            this.declaration = declaration;
            break;
        }
        this.subnetwork = leftTuple instanceof SubnetworkTuple;
        if (!this.subnetwork) {
            return handle;
        }
        this.offset = UniAccumulator.findTupleOffset(this.declaration, leftTuple);
        return UniAccumulator.getTuple(this.offset, leftTuple).getFactHandle();
    }
}

