/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.projectjobscheduling.score.capacity;

import java.util.HashMap;
import java.util.Map;
import org.optaplanner.examples.projectjobscheduling.domain.Allocation;
import org.optaplanner.examples.projectjobscheduling.domain.ResourceRequirement;
import org.optaplanner.examples.projectjobscheduling.domain.resource.Resource;
import org.optaplanner.examples.projectjobscheduling.score.capacity.ResourceCapacityTracker;

public class RenewableResourceCapacityTracker
extends ResourceCapacityTracker {
    protected int capacityEveryDay;
    protected Map<Integer, Integer> usedPerDay;
    protected int hardScore;

    public RenewableResourceCapacityTracker(Resource resource) {
        super(resource);
        if (!resource.isRenewable()) {
            throw new IllegalArgumentException("The resource (" + resource + ") is expected to be renewable.");
        }
        this.capacityEveryDay = resource.getCapacity();
        this.usedPerDay = new HashMap<Integer, Integer>();
        this.hardScore = 0;
    }

    @Override
    public void insert(ResourceRequirement resourceRequirement, Allocation allocation) {
        int startDate = allocation.getStartDate();
        int endDate = allocation.getEndDate();
        int requirement = resourceRequirement.getRequirement();
        for (int i = startDate; i < endDate; ++i) {
            Integer used = this.usedPerDay.get(i);
            if (used == null) {
                used = 0;
            }
            if (used > this.capacityEveryDay) {
                this.hardScore += used - this.capacityEveryDay;
            }
            if ((used = Integer.valueOf(used + requirement)) > this.capacityEveryDay) {
                this.hardScore -= used - this.capacityEveryDay;
            }
            this.usedPerDay.put(i, used);
        }
    }

    @Override
    public void retract(ResourceRequirement resourceRequirement, Allocation allocation) {
        int startDate = allocation.getStartDate();
        int endDate = allocation.getEndDate();
        int requirement = resourceRequirement.getRequirement();
        for (int i = startDate; i < endDate; ++i) {
            Integer used = this.usedPerDay.get(i);
            if (used == null) {
                used = 0;
            }
            if (used > this.capacityEveryDay) {
                this.hardScore += used - this.capacityEveryDay;
            }
            if ((used = Integer.valueOf(used - requirement)) > this.capacityEveryDay) {
                this.hardScore -= used - this.capacityEveryDay;
            }
            this.usedPerDay.put(i, used);
        }
    }

    @Override
    public int getHardScore() {
        return this.hardScore;
    }
}

