/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestsolutionmutation;

import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SubSingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemBasedSubSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.solution.mutation.MutationCounter;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.solver.DefaultSolver;

public class BestSolutionMutationSubSingleStatistic<Solution_>
extends ProblemBasedSubSingleStatistic<Solution_, BestSolutionMutationStatisticPoint> {
    private BestSolutionMutationSubSingleStatisticListener listener = new BestSolutionMutationSubSingleStatisticListener();

    public BestSolutionMutationSubSingleStatistic(SubSingleBenchmarkResult subSingleBenchmarkResult) {
        super(subSingleBenchmarkResult, ProblemStatisticType.BEST_SOLUTION_MUTATION);
    }

    @Override
    public void open(Solver<Solution_> solver) {
        DefaultSolver defaultSolver = (DefaultSolver)solver;
        InnerScoreDirectorFactory innerScoreDirectorFactory = defaultSolver.getScoreDirectorFactory();
        SolutionDescriptor solutionDescriptor = innerScoreDirectorFactory.getSolutionDescriptor();
        this.listener.setMutationCounter(new MutationCounter(solutionDescriptor));
        solver.addEventListener((SolverEventListener)this.listener);
    }

    @Override
    public void close(Solver<Solution_> solver) {
        solver.removeEventListener((SolverEventListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return BestSolutionMutationStatisticPoint.buildCsvLine("timeMillisSpent", "mutationCount");
    }

    @Override
    protected BestSolutionMutationStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new BestSolutionMutationStatisticPoint(Long.parseLong(csvLine.get(0)), Integer.parseInt(csvLine.get(1)));
    }

    private class BestSolutionMutationSubSingleStatisticListener
    implements SolverEventListener<Solution_> {
        private MutationCounter<Solution_> mutationCounter;
        private Solution_ oldBestSolution = null;

        private BestSolutionMutationSubSingleStatisticListener() {
        }

        private void setMutationCounter(MutationCounter<Solution_> mutationCounter) {
            if (this.mutationCounter != null) {
                throw new IllegalStateException("Impossible state: mutationCounter (" + this.mutationCounter + ") is not null.");
            }
            this.mutationCounter = mutationCounter;
        }

        public void bestSolutionChanged(BestSolutionChangedEvent<Solution_> event) {
            Object newBestSolution = event.getNewBestSolution();
            int mutationCount = this.oldBestSolution == null ? 0 : this.mutationCounter.countMutations(this.oldBestSolution, newBestSolution);
            BestSolutionMutationSubSingleStatistic.this.pointList.add(new BestSolutionMutationStatisticPoint(event.getTimeMillisSpent(), mutationCount));
            this.oldBestSolution = newBestSolution;
        }
    }
}

