/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.impl.score.stream;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.score.DefaultScoreExplanation;
import org.optaplanner.test.api.score.stream.MultiConstraintAssertion;

public final class DefaultMultiConstraintAssertion<Solution_, Score_ extends Score<Score_>>
implements MultiConstraintAssertion {
    private final ConstraintProvider constraintProvider;
    private final Score_ actualScore;
    private final Collection<ConstraintMatchTotal<Score_>> constraintMatchTotalCollection;
    private final Collection<Indictment<Score_>> indictmentCollection;

    protected DefaultMultiConstraintAssertion(ConstraintProvider constraintProvider, Score_ actualScore, Map<String, ConstraintMatchTotal<Score_>> constraintMatchTotalMap, Map<Object, Indictment<Score_>> indictmentMap) {
        this.constraintProvider = Objects.requireNonNull(constraintProvider);
        this.actualScore = (Score)Objects.requireNonNull(actualScore);
        this.constraintMatchTotalCollection = Objects.requireNonNull(constraintMatchTotalMap).values();
        this.indictmentCollection = Objects.requireNonNull(indictmentMap).values();
    }

    @Override
    public final void scores(Score<?> score, String message) {
        if (this.actualScore.equals(score)) {
            return;
        }
        Class<?> constraintProviderClass = this.constraintProvider.getClass();
        String expectation = message == null ? "Broken expectation." : message;
        throw new AssertionError((Object)(expectation + System.lineSeparator() + "  Constraint provider: " + constraintProviderClass + System.lineSeparator() + "       Expected score: " + score + " (" + score.getClass() + ")" + System.lineSeparator() + "         Actual score: " + this.actualScore + " (" + this.actualScore.getClass() + ")" + System.lineSeparator() + System.lineSeparator() + "  " + DefaultScoreExplanation.explainScore(this.actualScore, this.constraintMatchTotalCollection, this.indictmentCollection)));
    }
}

