/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.app;

import java.time.Duration;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;
import org.optaplanner.examples.cloudbalancing.persistence.CloudBalancingGenerator;
import org.optaplanner.examples.cloudbalancing.score.CloudBalancingConstraintProvider;

public class CloudBalancingHelloWorld {
    public static void main(String[] args) {
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)new SolverConfig().withSolutionClass(CloudBalance.class).withEntityClasses(new Class[]{CloudProcess.class}).withConstraintProviderClass(CloudBalancingConstraintProvider.class).withTerminationSpentLimit(Duration.ofMinutes(2L)));
        Solver solver = solverFactory.buildSolver();
        CloudBalance unsolvedCloudBalance = new CloudBalancingGenerator().createCloudBalance(400, 1200);
        CloudBalance solvedCloudBalance = (CloudBalance)solver.solve((Object)unsolvedCloudBalance);
        System.out.println("\nSolved cloudBalance with 400 computers and 1200 processes:\n" + CloudBalancingHelloWorld.toDisplayString(solvedCloudBalance));
    }

    public static String toDisplayString(CloudBalance cloudBalance) {
        StringBuilder displayString = new StringBuilder();
        for (CloudProcess process : cloudBalance.getProcessList()) {
            CloudComputer computer = process.getComputer();
            displayString.append("  ").append(process.getLabel()).append(" -> ").append(computer == null ? null : computer.getLabel()).append("\n");
        }
        return displayString.toString();
    }
}

