/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.optaplanner.examples.common.persistence.SolutionConverter;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;

public class ExaminationExporter
extends AbstractTxtSolutionExporter<Examination> {
    private static final String OUTPUT_FILE_SUFFIX = "sln";

    public static void main(String[] args) {
        SolutionConverter<Examination> converter = SolutionConverter.createExportConverter("examination", Examination.class, new ExaminationExporter());
        converter.convertAll();
    }

    @Override
    public String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder<Examination> createTxtOutputBuilder() {
        return new ExaminationOutputBuilder();
    }

    public static class ExaminationOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder<Examination> {
        @Override
        public void writeSolution() throws IOException {
            Collections.sort(((Examination)this.solution).getExamList(), Comparator.comparingLong(AbstractPersistable::getId));
            for (Exam exam : ((Examination)this.solution).getExamList()) {
                this.bufferedWriter.write(exam.getPeriod().getId() + ", " + exam.getRoom().getId() + "\r\n");
            }
        }
    }
}

