/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.flightcrewscheduling.domain;

import java.util.Comparator;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.flightcrewscheduling.domain.Employee;
import org.optaplanner.examples.flightcrewscheduling.domain.Flight;
import org.optaplanner.examples.flightcrewscheduling.domain.Skill;

@PlanningEntity
public class FlightAssignment
extends AbstractPersistable
implements Comparable<FlightAssignment> {
    private static final Comparator<FlightAssignment> COMPARATOR = Comparator.comparing(FlightAssignment::getFlight).thenComparing(FlightAssignment::getIndexInFlight);
    private Flight flight;
    private int indexInFlight;
    private Skill requiredSkill;
    @PlanningVariable(valueRangeProviderRefs={"employeeRange"})
    private Employee employee;

    public long getFlightDurationInMinutes() {
        return this.flight.getDurationInMinutes();
    }

    @Override
    public String toString() {
        return this.flight + "-" + this.indexInFlight;
    }

    public Flight getFlight() {
        return this.flight;
    }

    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    public int getIndexInFlight() {
        return this.indexInFlight;
    }

    public void setIndexInFlight(int indexInFlight) {
        this.indexInFlight = indexInFlight;
    }

    public Skill getRequiredSkill() {
        return this.requiredSkill;
    }

    public void setRequiredSkill(Skill requiredSkill) {
        this.requiredSkill = requiredSkill;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    @Override
    public int compareTo(FlightAssignment o) {
        return COMPARATOR.compare(this, o);
    }
}

