/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.optional.solver.solution;

import java.util.List;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;

public class CheatingNQueensPhaseCommand
implements CustomPhaseCommand<NQueens> {
    public void changeWorkingSolution(ScoreDirector<NQueens> scoreDirector) {
        NQueens nQueens = (NQueens)scoreDirector.getWorkingSolution();
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        List<Row> rowList = nQueens.getRowList();
        if (n % 2 != 0) {
            Queen a = queenList.get(n - 1);
            scoreDirector.beforeVariableChanged((Object)a, "row");
            a.setRow(rowList.get(n - 1));
            scoreDirector.afterVariableChanged((Object)a, "row");
            --n;
        }
        int halfN = n / 2;
        if (n % 6 != 2) {
            for (int i = 0; i < halfN; ++i) {
                Queen a = queenList.get(i);
                scoreDirector.beforeVariableChanged((Object)a, "row");
                a.setRow(rowList.get(2 * i + 1));
                scoreDirector.afterVariableChanged((Object)a, "row");
                Queen b = queenList.get(halfN + i);
                scoreDirector.beforeVariableChanged((Object)b, "row");
                b.setRow(rowList.get(2 * i));
                scoreDirector.afterVariableChanged((Object)b, "row");
            }
        } else {
            for (int i = 0; i < halfN; ++i) {
                Queen a = queenList.get(i);
                scoreDirector.beforeVariableChanged((Object)a, "row");
                a.setRow(rowList.get((halfN + 2 * i - 1) % n));
                scoreDirector.afterVariableChanged((Object)a, "row");
                Queen b = queenList.get(n - i - 1);
                scoreDirector.beforeVariableChanged((Object)b, "row");
                b.setRow(rowList.get(n - 1 - (halfN + 2 * i - 1) % n));
                scoreDirector.afterVariableChanged((Object)b, "row");
            }
        }
        scoreDirector.triggerVariableListeners();
    }
}

