/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.optional.score;

import java.time.DayOfWeek;
import java.util.Comparator;
import java.util.Objects;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.domain.WeekendDefinition;
import org.optaplanner.examples.nurserostering.domain.contract.Contract;

public class EmployeeConsecutiveAssignmentStart
implements Comparable<EmployeeConsecutiveAssignmentStart> {
    private static final Comparator<EmployeeConsecutiveAssignmentStart> COMPARATOR = Comparator.comparing(EmployeeConsecutiveAssignmentStart::getEmployee).thenComparing(EmployeeConsecutiveAssignmentStart::getShiftDate);
    private Employee employee;
    private ShiftDate shiftDate;

    public static boolean isWeekendAndNotFirstDayOfWeekend(Employee employee, ShiftDate shiftDate) {
        DayOfWeek dayOfWeek;
        WeekendDefinition weekendDefinition = employee.getContract().getWeekendDefinition();
        return weekendDefinition.isWeekend(dayOfWeek = shiftDate.getDayOfWeek()) && weekendDefinition.getFirstDayOfWeekend() != dayOfWeek;
    }

    public static int getDistanceToFirstDayOfWeekend(Employee employee, ShiftDate shiftDate) {
        WeekendDefinition weekendDefinition = employee.getContract().getWeekendDefinition();
        DayOfWeek dayOfWeek = shiftDate.getDayOfWeek();
        DayOfWeek firstDayOfWeekend = weekendDefinition.getFirstDayOfWeekend();
        int distance = dayOfWeek.getValue() - firstDayOfWeekend.getValue();
        if (distance < 0) {
            distance += 7;
        }
        return distance;
    }

    public EmployeeConsecutiveAssignmentStart(Employee employee, ShiftDate shiftDate) {
        this.employee = employee;
        this.shiftDate = shiftDate;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public ShiftDate getShiftDate() {
        return this.shiftDate;
    }

    public void setShiftDate(ShiftDate shiftDate) {
        this.shiftDate = shiftDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeConsecutiveAssignmentStart other = (EmployeeConsecutiveAssignmentStart)o;
        return Objects.equals(this.employee, other.employee) && Objects.equals(this.shiftDate, other.shiftDate);
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.shiftDate);
    }

    @Override
    public int compareTo(EmployeeConsecutiveAssignmentStart other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return this.employee + " " + this.shiftDate + " - ...";
    }

    public Contract getContract() {
        return this.employee.getContract();
    }

    public int getShiftDateDayIndex() {
        return this.shiftDate.getDayIndex();
    }

    public boolean isWeekendAndNotFirstDayOfWeekend() {
        return EmployeeConsecutiveAssignmentStart.isWeekendAndNotFirstDayOfWeekend(this.employee, this.shiftDate);
    }

    public int getDistanceToFirstDayOfWeekend() {
        return EmployeeConsecutiveAssignmentStart.getDistanceToFirstDayOfWeekend(this.employee, this.shiftDate);
    }
}

