/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.migration.v8;

import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.optaplanner.migration.v8.ScoreGettersRecipe;

class ScoreGettersRecipeTest
implements RewriteTest {
    ScoreGettersRecipeTest() {
    }

    public void defaults(RecipeSpec spec) {
        spec.recipe((Recipe)new ScoreGettersRecipe()).parser((Parser.Builder)ScoreGettersRecipe.buildJavaParser());
    }

    @Test
    void bendableScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.bendable.BendableScore", "BendableScore score = BendableScore.of(new int[] {1, 2}, new int[] {3, 4});", "int scoreLevelsSize = score.getLevelsSize();\nint hardScoreLevelsSize = score.getHardLevelsSize();\nint[] hardScores = score.getHardScores();\nint hardScore0 = score.getHardScore(0);\nint softScoreLevelsSize = score.getSoftLevelsSize();\nint[] softScores = score.getSoftScores();\nint softScore1 = score.getSoftScore(1);\nint initScore = score.getInitScore();\n", "int scoreLevelsSize = score.levelsSize();\nint hardScoreLevelsSize = score.hardLevelsSize();\nint[] hardScores = score.hardScores();\nint hardScore0 = score.hardScore(0);\nint softScoreLevelsSize = score.softLevelsSize();\nint[] softScores = score.softScores();\nint softScore1 = score.softScore(1);\nint initScore = score.initScore();\n");
    }

    @Test
    void bendableBigDecimalScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.bendablebigdecimal.BendableBigDecimalScore", "BendableBigDecimalScore score = BendableBigDecimalScore.of(\n   new BigDecimal[] {BigDecimal.ONE},\n   new BigDecimal[] {BigDecimal.ONE, BigDecimal.TEN});", "int scoreLevelsSize = score.getLevelsSize();\nint hardScoreLevelsSize = score.getHardLevelsSize();\nBigDecimal[] hardScores = score.getHardScores();\nBigDecimal hardScore0 = score.getHardScore(0);\nint softScoreLevelsSize = score.getSoftLevelsSize();\nBigDecimal[] softScores = score.getSoftScores();\nBigDecimal softScore1 = score.getSoftScore(1);\nint initScore = score.getInitScore();\n", "int scoreLevelsSize = score.levelsSize();\nint hardScoreLevelsSize = score.hardLevelsSize();\nBigDecimal[] hardScores = score.hardScores();\nBigDecimal hardScore0 = score.hardScore(0);\nint softScoreLevelsSize = score.softLevelsSize();\nBigDecimal[] softScores = score.softScores();\nBigDecimal softScore1 = score.softScore(1);\nint initScore = score.initScore();\n");
    }

    @Test
    void bendableLongScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore", "BendableLongScore score = BendableLongScore.of(   new long[] {1L},    new long[] {1L, 10L});", "int scoreLevelsSize = score.getLevelsSize();\nint hardScoreLevelsSize = score.getHardLevelsSize();\nlong[] hardScores = score.getHardScores();\nlong hardScore0 = score.getHardScore(0);\nint softScoreLevelsSize = score.getSoftLevelsSize();\nlong[] softScores = score.getSoftScores();\nlong softScore1 = score.getSoftScore(1);\nint initScore = score.getInitScore();\n", "int scoreLevelsSize = score.levelsSize();\nint hardScoreLevelsSize = score.hardLevelsSize();\nlong[] hardScores = score.hardScores();\nlong hardScore0 = score.hardScore(0);\nint softScoreLevelsSize = score.softLevelsSize();\nlong[] softScores = score.softScores();\nlong softScore1 = score.softScore(1);\nint initScore = score.initScore();\n");
    }

    @Test
    void hardMediumSoftScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore", "HardMediumSoftScore score = HardMediumSoftScore.of(1, 2, 3);", "int hardScore = score.getHardScore();\nint mediumScore = score.getMediumScore();\nint softScore = score.getSoftScore();\nint initScore = score.getInitScore();\n", "int hardScore = score.hardScore();\nint mediumScore = score.mediumScore();\nint softScore = score.softScore();\nint initScore = score.initScore();\n");
    }

    @Test
    void hardMediumSoftBigDecimalScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.hardmediumsoftbigdecimal.HardMediumSoftBigDecimalScore", "HardMediumSoftBigDecimalScore score = HardMediumSoftBigDecimalScore.of(BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.TEN);", "BigDecimal hardScore = score.getHardScore();\nBigDecimal mediumScore = score.getMediumScore();\nBigDecimal softScore = score.getSoftScore();\nint initScore = score.getInitScore();\n", "BigDecimal hardScore = score.hardScore();\nBigDecimal mediumScore = score.mediumScore();\nBigDecimal softScore = score.softScore();\nint initScore = score.initScore();\n");
    }

    @Test
    void hardMediumSoftLongScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore", "HardMediumSoftLongScore score = HardMediumSoftLongScore.of(1L, 2L, 3L);", "long hardScore = score.getHardScore();\nlong mediumScore = score.getMediumScore();\nlong softScore = score.getSoftScore();\nint initScore = score.getInitScore();\n", "long hardScore = score.hardScore();\nlong mediumScore = score.mediumScore();\nlong softScore = score.softScore();\nint initScore = score.initScore();\n");
    }

    @Test
    void hardSoftScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore", "HardSoftScore score = HardSoftScore.of(1, 2);", "int hardScore = score.getHardScore();\nint softScore = score.getSoftScore();\nint initScore = score.getInitScore();\n", "int hardScore = score.hardScore();\nint softScore = score.softScore();\nint initScore = score.initScore();\n");
    }

    @Test
    void hardSoftBigDecimalScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore", "HardSoftBigDecimalScore score = HardSoftBigDecimalScore.of(BigDecimal.ZERO, BigDecimal.ONE);", "BigDecimal hardScore = score.getHardScore();\nBigDecimal softScore = score.getSoftScore();\nint initScore = score.getInitScore();\n", "BigDecimal hardScore = score.hardScore();\nBigDecimal softScore = score.softScore();\nint initScore = score.initScore();\n");
    }

    @Test
    void hardSoftLongScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore", "HardSoftLongScore score = HardSoftLongScore.of(1L, 2L);", "long hardScore = score.getHardScore();\nlong softScore = score.getSoftScore();\nint initScore = score.getInitScore();\n", "long hardScore = score.hardScore();\nlong softScore = score.softScore();\nint initScore = score.initScore();\n");
    }

    @Test
    void simpleScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.simple.SimpleScore", "SimpleScore score = SimpleScore.of(1);", "int value = score.getScore();\nint initScore = score.getInitScore();\n", "int value = score.score();\nint initScore = score.initScore();\n");
    }

    @Test
    void simpleBigDecimalScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore", "SimpleBigDecimalScore score = SimpleBigDecimalScore.of(BigDecimal.ONE);", "BigDecimal value = score.getScore();\nint initScore = score.getInitScore();\n", "BigDecimal value = score.score();\nint initScore = score.initScore();\n");
    }

    @Test
    void simpleLongScore() {
        this.runTest("org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore", "SimpleLongScore score = SimpleLongScore.of(1L);", "long value = score.getScore();\nint initScore = score.getInitScore();\n", "long value = score.score();\nint initScore = score.initScore();\n");
    }

    private void runTest(String scoreImplClassFqn, String scoreDeclaration, String before, String after) {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)ScoreGettersRecipeTest.wrap(scoreImplClassFqn, scoreDeclaration, before), (String)ScoreGettersRecipeTest.wrap(scoreImplClassFqn, scoreDeclaration, after))});
    }

    private static String wrap(String scoreImplClassFqn, String scoreDeclaration, String content) {
        return "import java.math.BigDecimal;\nimport " + scoreImplClassFqn + ";\n\nclass Test {\n    public static void main(String[] args) {\n" + scoreDeclaration.trim() + "\n" + content.trim() + "\n    }}\n";
    }
}

