/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.Operator;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaplanner.operator.impl.solver.AbstractKubernetesTest;
import org.optaplanner.operator.impl.solver.model.AmqBroker;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverStatus;
import org.optaplanner.operator.impl.solver.model.Scaling;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObject;
import org.optaplanner.operator.impl.solver.model.keda.ScaledObjectSpec;
import org.optaplanner.operator.impl.solver.model.keda.SecretTargetRef;
import org.optaplanner.operator.impl.solver.model.keda.Trigger;
import org.optaplanner.operator.impl.solver.model.keda.TriggerAuthentication;
import org.optaplanner.operator.impl.solver.model.keda.TriggerAuthenticationSpec;

@QuarkusTest
public class OptaPlannerSolverReconcilerTest
extends AbstractKubernetesTest {
    @Inject
    private Operator operator;
    private String namespace;

    public void onStart(@Observes StartupEvent startupEvent) {
        this.operator.start();
    }

    @BeforeEach
    public void createNamespace() {
        this.namespace = "test-" + UUID.randomUUID();
    }

    @Test
    void createMandatoryDependentResources() {
        OptaPlannerSolver solver = new OptaPlannerSolver();
        String solverName = "test-solver";
        AmqBroker amqBroker = this.createAmqBroker();
        solver.getMetadata().setName("test-solver");
        solver.getMetadata().setNamespace(this.namespace);
        solver.setSpec((Object)new OptaPlannerSolverSpec());
        ((OptaPlannerSolverSpec)solver.getSpec()).setTemplate(this.createPodTemplateSpec("solver-project-image"));
        ((OptaPlannerSolverSpec)solver.getSpec()).setAmqBroker(amqBroker);
        ((OptaPlannerSolverSpec)solver.getSpec()).setScaling(new Scaling());
        this.getClient().resources(OptaPlannerSolver.class).create((Object)solver);
        String expectedMessageAddressIn = solver.getInputMessageAddressName();
        String expectedMessageAddressOut = solver.getOutputMessageAddressName();
        Awaitility.await().ignoreException(NullPointerException.class).atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            OptaPlannerSolver updatedSolver = (OptaPlannerSolver)((Resource)((NonNamespaceOperation)this.getClient().resources(OptaPlannerSolver.class).inNamespace(solver.getMetadata().getNamespace())).withName(solver.getMetadata().getName())).get();
            Assertions.assertThat((Object)((OptaPlannerSolverStatus)updatedSolver.getStatus())).isNotNull();
            Assertions.assertThat((List)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getConditions()).isNotEmpty();
            Condition condition = (Condition)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getConditions().get(0);
            this.assertStatusCondition(condition, updatedSolver, OptaPlannerSolverStatus.ConditionStatus.TRUE);
            Assertions.assertThat((String)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getInputMessageAddress()).isEqualTo(expectedMessageAddressIn);
            Assertions.assertThat((String)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getOutputMessageAddress()).isEqualTo(expectedMessageAddressOut);
        });
        ConfigMap configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.getClient().resources(ConfigMap.class).inNamespace(solver.getMetadata().getNamespace())).withName(solver.getConfigMapName())).get();
        Map configMapData = configMap.getData();
        Assertions.assertThat((String)((String)configMapData.get("solver.message.input"))).isEqualTo(expectedMessageAddressIn);
        Assertions.assertThat((String)((String)configMapData.get("solver.message.output"))).isEqualTo(expectedMessageAddressOut);
        List deployments = ((KubernetesResourceList)((NonNamespaceOperation)this.getClient().resources(Deployment.class).inNamespace(solver.getMetadata().getNamespace())).list()).getItems();
        Assertions.assertThat((List)deployments).hasSize(1);
        Assertions.assertThat((String)((Deployment)deployments.get(0)).getMetadata().getName()).isEqualTo("test-solver");
    }

    @Test
    void dynamicScaling_configuresKeda() {
        String solverName = "test-solver";
        AmqBroker amqBroker = this.createAmqBroker();
        int maxReplicas = 5;
        OptaPlannerSolver solver = new OptaPlannerSolver();
        solver.getMetadata().setName("test-solver");
        solver.getMetadata().setNamespace(this.namespace);
        solver.setSpec((Object)new OptaPlannerSolverSpec());
        ((OptaPlannerSolverSpec)solver.getSpec()).setTemplate(this.createPodTemplateSpec("solver-project-image"));
        ((OptaPlannerSolverSpec)solver.getSpec()).setAmqBroker(amqBroker);
        ((OptaPlannerSolverSpec)solver.getSpec()).setScaling(new Scaling(true, 5));
        this.getClient().resources(OptaPlannerSolver.class).create((Object)solver);
        Awaitility.await().ignoreException(NullPointerException.class).atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            OptaPlannerSolver updatedSolver = (OptaPlannerSolver)((Resource)((NonNamespaceOperation)this.getClient().resources(OptaPlannerSolver.class).inNamespace(solver.getMetadata().getNamespace())).withName(solver.getMetadata().getName())).get();
            Assertions.assertThat((String)((Condition)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getConditions().get(0)).getStatus()).isNotEqualTo((Object)OptaPlannerSolverStatus.ConditionStatus.UNKNOWN.getName());
        });
        ScaledObject scaledObject = (ScaledObject)((Resource)((NonNamespaceOperation)this.getClient().resources(ScaledObject.class).inNamespace(solver.getMetadata().getNamespace())).withName("test-solver")).get();
        TriggerAuthentication triggerAuthentication = (TriggerAuthentication)((Resource)((NonNamespaceOperation)this.getClient().resources(TriggerAuthentication.class).inNamespace(solver.getMetadata().getNamespace())).withName("test-solver")).get();
        Assertions.assertThat((String)((ScaledObjectSpec)scaledObject.getSpec()).getScaleTargetRef().getName()).isEqualTo("test-solver");
        Assertions.assertThat((List)((ScaledObjectSpec)scaledObject.getSpec()).getTriggers()).hasSize(1);
        Trigger trigger = (Trigger)((ScaledObjectSpec)scaledObject.getSpec()).getTriggers().get(0);
        Assertions.assertThat((String)trigger.getType()).isEqualTo("artemis-queue");
        Assertions.assertThat((String)trigger.getMetadata().getQueueName()).isEqualTo(solver.getInputMessageAddressName());
        Assertions.assertThat((String)trigger.getAuthenticationRef().getName()).isEqualTo(triggerAuthentication.getMetadata().getName());
        List secretTargetRefs = ((TriggerAuthenticationSpec)triggerAuthentication.getSpec()).getSecretTargetRefs();
        Assertions.assertThat((List)secretTargetRefs).hasSize(2);
        Assertions.assertThat((List)secretTargetRefs).allSatisfy(secretTargetRef -> {
            if ("username".equals(secretTargetRef.getParameter())) {
                this.assertSecretTargetRefFromSecretKeySelector((SecretTargetRef)secretTargetRef, amqBroker.getUsernameSecretRef());
            } else {
                this.assertSecretTargetRefFromSecretKeySelector((SecretTargetRef)secretTargetRef, amqBroker.getPasswordSecretRef());
            }
        });
    }

    @Test
    void incorrectSolverResource_FailedCondition() {
        OptaPlannerSolver solver = new OptaPlannerSolver();
        String solverName = "incorrect-solver";
        solver.getMetadata().setName("incorrect-solver");
        solver.getMetadata().setNamespace(this.namespace);
        solver.setSpec((Object)new OptaPlannerSolverSpec());
        this.getClient().resources(OptaPlannerSolver.class).create((Object)solver);
        Awaitility.await().ignoreException(NullPointerException.class).atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            OptaPlannerSolver updatedSolver = (OptaPlannerSolver)((Resource)((NonNamespaceOperation)this.getClient().resources(OptaPlannerSolver.class).inNamespace(solver.getMetadata().getNamespace())).withName(solver.getMetadata().getName())).get();
            Assertions.assertThat((List)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getConditions()).isNotEmpty();
            Condition condition = (Condition)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getConditions().get(0);
            this.assertStatusCondition(condition, updatedSolver, OptaPlannerSolverStatus.ConditionStatus.FALSE);
        });
    }

    @Test
    void mergePodTemplate() {
        OptaPlannerSolver solver = new OptaPlannerSolver();
        String solverName = "test-solver-merge-environment";
        solver.getMetadata().setName("test-solver-merge-environment");
        solver.getMetadata().setNamespace(this.namespace);
        solver.setSpec((Object)new OptaPlannerSolverSpec());
        ((OptaPlannerSolverSpec)solver.getSpec()).setAmqBroker(this.createAmqBroker());
        EnvVar existingEnvVar = ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName("test-var")).withValue("test-var-value")).build();
        PodTemplateSpec podTemplateSpec = ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.SpecNested)((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecFluent.MetadataNested)new PodTemplateSpecBuilder().withNewMetadata().withName("test-pod-template")).addToLabels("test-label", "test-label-value")).endMetadata()).withNewSpec().withContainers(new Container[]{((ContainerBuilder)((ContainerFluent.ResourcesNested)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withImage("solver-project-image")).withEnv(new EnvVar[]{existingEnvVar})).withNewResources().addToRequests("cpu", Quantity.parse((String)"1"))).endResources()).build()})).endSpec()).build();
        ((OptaPlannerSolverSpec)solver.getSpec()).setTemplate(podTemplateSpec);
        this.getClient().resources(OptaPlannerSolver.class).create((Object)solver);
        Awaitility.await().ignoreException(NullPointerException.class).atMost(1L, TimeUnit.MINUTES).untilAsserted(() -> {
            OptaPlannerSolver updatedSolver = (OptaPlannerSolver)((Resource)((NonNamespaceOperation)this.getClient().resources(OptaPlannerSolver.class).inNamespace(solver.getMetadata().getNamespace())).withName(solver.getMetadata().getName())).get();
            Assertions.assertThat((String)((Condition)((OptaPlannerSolverStatus)updatedSolver.getStatus()).getConditions().get(0)).getStatus()).isNotEqualTo((Object)OptaPlannerSolverStatus.ConditionStatus.UNKNOWN.getName());
        });
        List deployments = ((KubernetesResourceList)((NonNamespaceOperation)this.getClient().resources(Deployment.class).inNamespace(solver.getMetadata().getNamespace())).list()).getItems();
        Assertions.assertThat((List)deployments).hasSize(1);
        PodTemplateSpec resolvedPodTemplateSpec = ((Deployment)deployments.get(0)).getSpec().getTemplate();
        Assertions.assertThat((String)resolvedPodTemplateSpec.getMetadata().getName()).isEqualTo(podTemplateSpec.getMetadata().getName());
        Assertions.assertThat((Map)resolvedPodTemplateSpec.getMetadata().getLabels()).containsOnlyKeys((Object[])new String[]{"app", "test-label"});
        Assertions.assertThat((List)resolvedPodTemplateSpec.getSpec().getContainers()).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)((Container)resolvedPodTemplateSpec.getSpec().getContainers().get(0)).getEnv()).hasSizeGreaterThan(1)).contains((Object[])new EnvVar[]{existingEnvVar});
        Assertions.assertThat((Map)((Container)resolvedPodTemplateSpec.getSpec().getContainers().get(0)).getResources().getRequests()).containsOnlyKeys((Object[])new String[]{"cpu"});
    }

    private KubernetesClient getClient() {
        return this.getMockServer().getClient().inNamespace(this.namespace);
    }

    private void assertSecretTargetRefFromSecretKeySelector(SecretTargetRef secretTargetRef, SecretKeySelector secretKeySelector) {
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(secretTargetRef.getName()).isEqualTo(secretKeySelector.getName());
            softly.assertThat(secretTargetRef.getKey()).isEqualTo(secretKeySelector.getKey());
        });
    }

    private void assertStatusCondition(Condition condition, OptaPlannerSolver optaPlannerSolver, OptaPlannerSolverStatus.ConditionStatus expectedStatus) {
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(condition.getType()).isEqualTo("Ready");
            softly.assertThat(condition.getStatus()).isEqualTo(expectedStatus.getName());
            softly.assertThat(condition.getLastTransitionTime()).isNotEmpty();
            softly.assertThat(condition.getObservedGeneration()).isEqualTo((Object)optaPlannerSolver.getMetadata().getGeneration());
        });
    }

    private AmqBroker createAmqBroker() {
        AmqBroker amqBroker = new AmqBroker();
        amqBroker.setHost("amq-host");
        amqBroker.setPort(5678);
        amqBroker.setUsernameSecretRef(new SecretKeySelector("amq-username", "my-secret", Boolean.valueOf(false)));
        amqBroker.setPasswordSecretRef(new SecretKeySelector("amq-password", "my-secret", Boolean.valueOf(false)));
        return amqBroker;
    }

    private PodTemplateSpec createPodTemplateSpec(String imageName) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.SpecNested)new PodTemplateSpecBuilder().withNewSpec().withContainers(new Container[]{((ContainerBuilder)new ContainerBuilder().withImage(imageName)).build()})).endSpec()).build();
    }
}

