/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.operator.impl.solver.model.keda;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolver;
import org.optaplanner.operator.impl.solver.model.OptaPlannerSolverSpec;
import org.optaplanner.operator.impl.solver.model.keda.SecretTargetRef;
import org.optaplanner.operator.impl.solver.model.keda.TriggerAuthentication;
import org.optaplanner.operator.impl.solver.model.keda.TriggerAuthenticationSpec;

@KubernetesDependent
public final class TriggerAuthenticationDependentResource
extends CRUDKubernetesDependentResource<TriggerAuthentication, OptaPlannerSolver> {
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";

    public TriggerAuthenticationDependentResource(KubernetesClient kubernetesClient) {
        super(TriggerAuthentication.class);
        this.setKubernetesClient(kubernetesClient);
    }

    protected TriggerAuthentication desired(OptaPlannerSolver optaPlannerSolver, Context<OptaPlannerSolver> context) {
        SecretKeySelector amqUsernameSecretKeySelector = ((OptaPlannerSolverSpec)optaPlannerSolver.getSpec()).getAmqBroker().getUsernameSecretRef();
        SecretKeySelector amqPasswordSecretKeySelector = ((OptaPlannerSolverSpec)optaPlannerSolver.getSpec()).getAmqBroker().getPasswordSecretRef();
        TriggerAuthenticationSpec spec = new TriggerAuthenticationSpec().withSecretTargetRef(SecretTargetRef.fromSecretKeySelector(PARAM_USERNAME, amqUsernameSecretKeySelector)).withSecretTargetRef(SecretTargetRef.fromSecretKeySelector(PARAM_PASSWORD, amqPasswordSecretKeySelector));
        ObjectMeta metadata = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(optaPlannerSolver.getTriggerAuthenticationName())).withNamespace(optaPlannerSolver.getNamespace())).build();
        TriggerAuthentication triggerAuthentication = new TriggerAuthentication();
        triggerAuthentication.setMetadata(metadata);
        triggerAuthentication.setSpec(spec);
        return triggerAuthentication;
    }
}

