/*
 * Decompiled with CFR 0.152.
 */
package org.javanetworkanalyzer.analyzers;

import java.lang.reflect.InvocationTargetException;
import org.javanetworkanalyzer.alg.DijkstraForCentrality;
import org.javanetworkanalyzer.analyzers.GraphAnalyzer;
import org.javanetworkanalyzer.data.VWCent;
import org.javanetworkanalyzer.data.WeightedPathLengthData;
import org.javanetworkanalyzer.model.EdgeCent;
import org.javanetworkanalyzer.progress.NullProgressMonitor;
import org.javanetworkanalyzer.progress.ProgressMonitor;
import org.jgrapht.WeightedGraph;

public class WeightedGraphAnalyzer<E extends EdgeCent>
extends GraphAnalyzer<VWCent, E, WeightedPathLengthData> {
    private final DijkstraForCentrality<E> dijkstra;

    public WeightedGraphAnalyzer(WeightedGraph<VWCent, E> graph, ProgressMonitor pm) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        super(graph, pm);
        this.dijkstra = new DijkstraForCentrality<E>(graph, this.stack);
    }

    public WeightedGraphAnalyzer(WeightedGraph<VWCent, E> graph) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this(graph, (ProgressMonitor)new NullProgressMonitor());
    }

    protected DijkstraForCentrality<E> calculateShortestPathsFromNode(VWCent startNode) {
        this.dijkstra.calculate(startNode);
        return this.dijkstra;
    }

    @Override
    public void computeAll() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.pm.startTask("Weighted graph analysis", this.nodeCount);
        super.computeAll();
        this.pm.endTask();
    }
}

