/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.server.jdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.model.wadl.Description;

@Path(value="/")
@Produces(value={"image/png", "application/json", "text/html", "text/css", "text/javascript"})
@Description(value="")
public class TileFetcher {
    private static final Log log = LogFactory.getLog(TileFetcher.class);
    static ObjectMapper om = new ObjectMapper();
    HashMap<String, Connection> connections = new HashMap();

    public TileFetcher() throws Exception {
        this.initDatabases();
    }

    private void initDatabases() throws Exception {
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream("sources.properties");
        p.load(fis);
        fis.close();
        fis = null;
        for (Map.Entry<Object, Object> next : p.entrySet()) {
            String source = (String)next.getKey();
            String filename = (String)next.getValue();
            File db = new File(filename);
            if (!db.exists()) {
                throw new FileNotFoundException("can't find the db " + filename + " current dir is " + new File(".").getAbsolutePath());
            }
            try {
                Connection conn1 = DriverManager.getConnection("jdbc:sqlite:" + filename);
                Statement stat = conn1.createStatement();
                stat.executeUpdate("CREATE TABLE IF NOT EXISTS tiles (key INTEGER PRIMARY KEY, provider TEXT, tile BLOB)");
                stat.close();
                System.out.println("adding " + source + " from file " + filename);
                this.connections.put(source, conn1);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @GET
    @Path(value="/sources")
    @Produces(value={"application/json"})
    @Description(value="Returns a JSON string array of all available map sources")
    public String getSourceList() throws WebApplicationException, JsonProcessingException {
        System.out.println("getSourceList");
        return om.writeValueAsString(this.connections.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{source}/{z}/{x}/{y}.png")
    @Produces(value={"image/png"})
    @Description(value="Returns png of the specific map tile from the database")
    public byte[] getImage(@PathParam(value="source") String id, @PathParam(value="z") int z, @PathParam(value="x") int x, @PathParam(value="y") int y) throws WebApplicationException {
        long index;
        block6: {
            byte[] image2;
            Connection c = this.connections.get(id);
            if (c == null) {
                System.err.println(id + " isn't registered");
                throw new WebApplicationException((Throwable)new Exception(id + " is not a valid tile source"), 400);
            }
            PreparedStatement prep = c.prepareStatement("Select tile from tiles where key=?;");
            index = ((z << z) + x << z) + y;
            System.out.println("Fetching tile " + id + z + "/" + x + "/" + y + " as " + index);
            prep.setLong(1, index);
            ResultSet executeQuery = prep.executeQuery();
            if (!executeQuery.next()) break block6;
            byte[] byArray = image2 = executeQuery.getBytes(1);
            return byArray;
        }
        try {
            System.out.println(id + "Tile not found " + z + "/" + x + "/" + y + " as " + index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw new WebApplicationException(404);
    }

    @GET
    @Path(value="/index.html")
    @Produces(value={"text/html"})
    @Description(value="Returns a basic html viewer of the slippy map")
    public String getIndex() throws WebApplicationException {
        return TileFetcher.getFile("www/openlayers.html");
    }

    @GET
    @Path(value="/")
    @Produces(value={"text/html"})
    @Description(value="Returns a basic html viewer of the slippy map")
    public String getIndex4() throws WebApplicationException {
        return TileFetcher.getFile("www/openlayers.html");
    }

    @GET
    @Path(value="/v3.5.0-dist/ol.js")
    @Produces(value={"application/javascript"})
    @Description(value="Returns a basic html viewer of the slippy map")
    public String getIndex2() throws WebApplicationException {
        return TileFetcher.getFile("www/v3.5.0-dist/ol.js");
    }

    @GET
    @Path(value="/v3.5.0-dist/ol.css")
    @Produces(value={"text/css"})
    @Description(value="Returns a basic html viewer of the slippy map")
    public String getIndex3() throws WebApplicationException {
        return TileFetcher.getFile("www/v3.5.0-dist/ol.css");
    }

    public static String getFile(String f) {
        StringBuilder sb = new StringBuilder();
        try {
            FileInputStream r = new FileInputStream(f);
            int c = 0;
            while ((c = r.read()) != -1) {
                sb.append((char)c);
            }
            r.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Current dir is " + new File(".").getAbsolutePath());
        }
        return sb.toString();
    }
}

