/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.server.jdk;

import java.util.ArrayList;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.osmdroid.server.jdk.TileFetcher;

public class TileServer {
    static int port = 80;
    static String ENDPOINT_ADDRESS;
    private static Server server;
    static TileFetcher instance;

    public static void main(String[] args) throws Exception {
        System.out.println("This will listen on port 80 by default for web traffic (on all IP addresses)");
        System.out.println("Usage");
        System.out.println("jar -jar <...with-dependencies.jar> <port>");
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ENDPOINT_ADDRESS = "http://0.0.0.0:" + port + "/";
        System.out.println("Attempting to bind to " + ENDPOINT_ADDRESS);
        TileServer.startServer();
        if (System.console() == null) {
            System.out.println("Server started at " + ENDPOINT_ADDRESS + " press Ctrl-C to stop.");
            while (true) {
                Thread.sleep(5000L);
            }
        }
        System.out.println("Server started at " + ENDPOINT_ADDRESS + " press enter to stop.");
        System.console().readLine();
        server.stop();
        server.destroy();
    }

    private static void startServer() throws Exception {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setResourceClasses(new Class[]{TileFetcher.class});
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new JAXBElementProvider());
        providers.add(new JSONProvider());
        sf.setProviders(providers);
        sf.setResourceProvider(TileFetcher.class, (ResourceProvider)new SingletonResourceProvider((Object)new TileFetcher(), true));
        sf.setAddress(ENDPOINT_ADDRESS);
        server = sf.create();
    }

    static {
        instance = null;
    }
}

