/*
 * Copyright (C) 2020 The ORT Project Authors (see <https://github.com/oss-review-toolkit/ort/blob/main/NOTICE>)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 * License-Filename: LICENSE
 */

package org.ossreviewtoolkit.model.vulnerabilities

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include

/**
 * Base model for all vulnerability providers supported by the advisor.
 *
 * This class stores the information about a single vulnerability, which may have been retrieved from multiple
 * vulnerability providers. For each source of information a [VulnerabilityReference] is contained.
 */
data class Vulnerability(
    /**
     * The ID of a vulnerability. Most likely a CVE identifier.
     */
    val id: String,

    /**
     * A short summary of this [Vulnerability].
     */
    @JsonInclude(Include.NON_NULL)
    val summary: String? = null,

    /**
     * A full description of this [Vulnerability].
     */
    @JsonInclude(Include.NON_NULL)
    val description: String? = null,

    /**
     * A list with detailed information for this vulnerability obtained from different sources.
     */
    val references: List<VulnerabilityReference>
)
