/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.AdvisorCapability;
import org.ossreviewtoolkit.model.AdvisorRecord;
import org.ossreviewtoolkit.model.AdvisorRecordKt;
import org.ossreviewtoolkit.model.AdvisorResult;
import org.ossreviewtoolkit.model.Defect;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Severity;
import org.ossreviewtoolkit.model.vulnerabilities.Vulnerability;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J%\u0010\u000b\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J0\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0011j\u0002`\u0012J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u0015\u001a\u00020\u0004J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0005\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0015\u001a\u00020\u00042\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00050\u0011H\u0002J\u001a\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0003H\u0007J\u001a\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00050\u0003H\u0007J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00052\u0006\u0010\u0015\u001a\u00020\u0004J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R(\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lorg/ossreviewtoolkit/model/AdvisorRecord;", "", "advisorResults", "", "Lorg/ossreviewtoolkit/model/Identifier;", "", "Lorg/ossreviewtoolkit/model/AdvisorResult;", "(Ljava/util/Map;)V", "getAdvisorResults", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "filterResults", "filter", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/AdvisorResultFilter;", "getDefects", "Lorg/ossreviewtoolkit/model/Defect;", "pkgId", "getFindings", "T", "selector", "getIssues", "", "Lorg/ossreviewtoolkit/model/Issue;", "getVulnerabilities", "Lorg/ossreviewtoolkit/model/vulnerabilities/Vulnerability;", "hashCode", "", "toString", "", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nAdvisorRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvisorRecord.kt\norg/ossreviewtoolkit/model/AdvisorRecord\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n215#2:145\n216#2:155\n135#2,9:167\n215#2:176\n216#2:182\n144#2:183\n1855#3:146\n1856#3:154\n1238#3,2:158\n1360#3:160\n1446#3,5:161\n1241#3:166\n766#3:177\n857#3,2:178\n1360#3:184\n1446#3,5:185\n372#4,7:147\n453#4:156\n403#4:157\n1#5:180\n1#5:181\n*S KotlinDebug\n*F\n+ 1 AdvisorRecord.kt\norg/ossreviewtoolkit/model/AdvisorRecord\n*L\n74#1:145\n74#1:155\n113#1:167,9\n113#1:176\n113#1:182\n113#1:183\n75#1:146\n75#1:154\n88#1:158,2\n89#1:160\n89#1:161,5\n88#1:166\n114#1:177\n114#1:178,2\n122#1:184\n122#1:185,5\n77#1:147,7\n88#1:156\n88#1:157\n113#1:181\n*E\n"})
public final class AdvisorRecord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JsonPropertyOrder(alphabetic=true)
    @NotNull
    private final Map<Identifier, List<AdvisorResult>> advisorResults;
    @NotNull
    private static final Function1<AdvisorResult, Boolean> RESULTS_WITH_VULNERABILITIES = Companion.RESULTS_WITH_VULNERABILITIES.1.INSTANCE;
    @NotNull
    private static final Function1<AdvisorResult, Boolean> RESULTS_WITH_DEFECTS = Companion.RESULTS_WITH_DEFECTS.1.INSTANCE;

    public AdvisorRecord(@NotNull Map<Identifier, ? extends List<AdvisorResult>> advisorResults) {
        Intrinsics.checkNotNullParameter(advisorResults, (String)"advisorResults");
        this.advisorResults = advisorResults;
    }

    @NotNull
    public final Map<Identifier, List<AdvisorResult>> getAdvisorResults() {
        return this.advisorResults;
    }

    @JsonIgnore
    @NotNull
    public final Map<Identifier, Set<Issue>> getIssues() {
        Map map;
        Map $this$getIssues_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Map<Identifier, List<AdvisorResult>> $this$forEach$iv = this.advisorResults;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Identifier, List<AdvisorResult>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Identifier, List<AdvisorResult>> element$iv;
            Map.Entry<Identifier, List<AdvisorResult>> entry = element$iv = iterator.next();
            boolean bl2 = false;
            Identifier id = entry.getKey();
            List<AdvisorResult> results = entry.getValue();
            Iterable $this$forEach$iv2 = results;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                AdvisorResult result = (AdvisorResult)element$iv2;
                boolean bl3 = false;
                if (!(!((Collection)result.getSummary().getIssues()).isEmpty())) continue;
                Map $this$getOrPut$iv = $this$getIssues_u24lambda_u243;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(id);
                if (value$iv == null) {
                    boolean bl4 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(id, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Collection collection = (Collection)object;
                CollectionsKt.addAll((Collection)collection, (Iterable)result.getSummary().getIssues());
            }
        }
        return MapsKt.build((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Map<Identifier, List<Vulnerability>> getVulnerabilities() {
        void $this$mapValuesTo$iv$iv;
        Map<Identifier, List<AdvisorResult>> $this$mapValues$iv = this.advisorResults;
        boolean $i$f$mapValues = false;
        Map<Identifier, List<AdvisorResult>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List results = (List)entry2.getValue();
            Iterable $this$flatMap$iv = results;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                AdvisorResult it = (AdvisorResult)element$iv$iv;
                boolean bl3 = false;
                Iterable list$iv$iv = it.getVulnerabilities();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List list = AdvisorRecordKt.access$mergeVulnerabilities((List)destination$iv$iv2);
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final List<Vulnerability> getVulnerabilities(@NotNull Identifier pkgId) {
        Intrinsics.checkNotNullParameter((Object)pkgId, (String)"pkgId");
        return AdvisorRecordKt.access$mergeVulnerabilities(this.getFindings(pkgId, getVulnerabilities.2.INSTANCE));
    }

    @NotNull
    public final List<Defect> getDefects(@NotNull Identifier pkgId) {
        Intrinsics.checkNotNullParameter((Object)pkgId, (String)"pkgId");
        return this.getFindings(pkgId, getDefects.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Identifier, List<AdvisorResult>> filterResults(@NotNull Function1<? super AdvisorResult, Boolean> filter) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Map<Identifier, List<AdvisorResult>> $this$mapNotNull$iv = this.advisorResults;
        boolean $i$f$mapNotNull = false;
        Map<Identifier, List<AdvisorResult>> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            List list;
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            Identifier id = (Identifier)entry.getKey();
            List results = (List)entry.getValue();
            Iterable $this$filter$iv = results;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                if (!((Boolean)filter.invoke(element$iv$iv2)).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List it = list = (List)destination$iv$iv2;
            boolean bl3 = false;
            List list2 = !((Collection)it).isEmpty() ? list : null;
            if (list2 != null) {
                it = list2;
                boolean bl4 = false;
                pair = TuplesKt.to((Object)id, (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> List<T> getFindings(Identifier pkgId, Function1<? super AdvisorResult, ? extends List<? extends T>> selector) {
        void $this$flatMapTo$iv$iv;
        List list = this.advisorResults.get(pkgId);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable list$iv$iv = (Iterable)selector.invoke(element$iv$iv);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<Identifier, List<AdvisorResult>> component1() {
        return this.advisorResults;
    }

    @NotNull
    public final AdvisorRecord copy(@NotNull Map<Identifier, ? extends List<AdvisorResult>> advisorResults) {
        Intrinsics.checkNotNullParameter(advisorResults, (String)"advisorResults");
        return new AdvisorRecord(advisorResults);
    }

    public static /* synthetic */ AdvisorRecord copy$default(AdvisorRecord advisorRecord, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = advisorRecord.advisorResults;
        }
        return advisorRecord.copy(map);
    }

    @NotNull
    public String toString() {
        return "AdvisorRecord(advisorResults=" + this.advisorResults + ")";
    }

    public int hashCode() {
        return ((Object)this.advisorResults).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AdvisorRecord)) {
            return false;
        }
        AdvisorRecord advisorRecord = (AdvisorRecord)other;
        return Intrinsics.areEqual(this.advisorResults, advisorRecord.advisorResults);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/model/AdvisorRecord$Companion;", "", "()V", "RESULTS_WITH_DEFECTS", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/AdvisorResult;", "", "Lorg/ossreviewtoolkit/model/AdvisorResultFilter;", "getRESULTS_WITH_DEFECTS", "()Lkotlin/jvm/functions/Function1;", "RESULTS_WITH_VULNERABILITIES", "getRESULTS_WITH_VULNERABILITIES", "resultsWithIssues", "minSeverity", "Lorg/ossreviewtoolkit/model/Severity;", "capability", "Lorg/ossreviewtoolkit/model/AdvisorCapability;", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<AdvisorResult, Boolean> getRESULTS_WITH_VULNERABILITIES() {
            return RESULTS_WITH_VULNERABILITIES;
        }

        @NotNull
        public final Function1<AdvisorResult, Boolean> getRESULTS_WITH_DEFECTS() {
            return RESULTS_WITH_DEFECTS;
        }

        @NotNull
        public final Function1<AdvisorResult, Boolean> resultsWithIssues(@NotNull Severity minSeverity, @Nullable AdvisorCapability capability) {
            Intrinsics.checkNotNullParameter((Object)((Object)minSeverity), (String)"minSeverity");
            return (Function1)new Function1<AdvisorResult, Boolean>(capability, minSeverity){
                final /* synthetic */ AdvisorCapability $capability;
                final /* synthetic */ Severity $minSeverity;
                {
                    this.$capability = $capability;
                    this.$minSeverity = $minSeverity;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull AdvisorResult result) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    if (this.$capability == null || result.getAdvisor().getCapabilities().contains((Object)((Object)this.$capability))) {
                        boolean bl2;
                        block5: {
                            void $this$any$iv;
                            Iterable iterable = result.getSummary().getIssues();
                            Severity severity = this.$minSeverity;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    Issue it = (Issue)element$iv;
                                    boolean bl3 = false;
                                    if (!(it.getSeverity().compareTo((Enum)severity) >= 0)) continue;
                                    bl2 = true;
                                    break block5;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            };
        }

        public static /* synthetic */ Function1 resultsWithIssues$default(Companion companion, Severity severity, AdvisorCapability advisorCapability, int n, Object object) {
            if ((n & 1) != 0) {
                severity = Severity.HINT;
            }
            if ((n & 2) != 0) {
                advisorCapability = null;
            }
            return companion.resultsWithIssues(severity, advisorCapability);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

