/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.AnalyzerResult;
import org.ossreviewtoolkit.model.DependencyGraph;
import org.ossreviewtoolkit.model.DependencyNavigator;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.Package;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.utils.PackageSortedSetConverter;
import org.ossreviewtoolkit.model.utils.ProjectSortedSetConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#BW\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u001a\b\u0003\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b\u0012\u0014\b\u0003\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\b\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u001b\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bH\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\bH\u00c6\u0003J[\u0010\u001a\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0003\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u001a\b\u0003\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0014\b\u0003\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\bH\u0007J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\"\u001a\u00020\u0000R\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/ossreviewtoolkit/model/AnalyzerResult;", "", "projects", "", "Lorg/ossreviewtoolkit/model/Project;", "packages", "Lorg/ossreviewtoolkit/model/Package;", "issues", "", "Lorg/ossreviewtoolkit/model/Identifier;", "", "Lorg/ossreviewtoolkit/model/Issue;", "dependencyGraphs", "", "Lorg/ossreviewtoolkit/model/DependencyGraph;", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "getDependencyGraphs", "()Ljava/util/Map;", "getIssues", "getPackages", "()Ljava/util/Set;", "getProjects", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getAllIssues", "hashCode", "", "toString", "withResolvedScopes", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nAnalyzerResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzerResult.kt\norg/ossreviewtoolkit/model/AnalyzerResult\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,117:1\n453#2:118\n403#2:119\n372#2,7:129\n372#2,7:140\n1238#3,4:120\n766#3:124\n857#3,2:125\n1855#3:127\n1856#3:137\n1855#3:138\n1856#3:148\n1620#3,3:149\n215#4:128\n216#4:136\n215#4:139\n216#4:147\n*S KotlinDebug\n*F\n+ 1 AnalyzerResult.kt\norg/ossreviewtoolkit/model/AnalyzerResult\n*L\n82#1:118\n82#1:119\n90#1:129,7\n96#1:140,7\n82#1:120,4\n87#1:124\n87#1:125,2\n87#1:127\n87#1:137\n94#1:138\n94#1:148\n110#1:149,3\n89#1:128\n89#1:136\n95#1:139\n95#1:147\n*E\n"})
public final class AnalyzerResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Project> projects;
    @NotNull
    private final Set<Package> packages;
    @JsonPropertyOrder(alphabetic=true)
    @NotNull
    private final Map<Identifier, List<Issue>> issues;
    @JsonPropertyOrder(alphabetic=true)
    @NotNull
    private final Map<String, DependencyGraph> dependencyGraphs;
    @JvmField
    @NotNull
    public static final AnalyzerResult EMPTY = new AnalyzerResult(SetsKt.emptySet(), SetsKt.emptySet(), MapsKt.emptyMap(), null, 8, null);

    public AnalyzerResult(@JsonSerialize(converter=ProjectSortedSetConverter.class) @NotNull Set<Project> projects2, @JsonSerialize(converter=PackageSortedSetConverter.class) @NotNull Set<Package> packages2, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<Identifier, ? extends List<Issue>> issues, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, DependencyGraph> dependencyGraphs) {
        Intrinsics.checkNotNullParameter(projects2, (String)"projects");
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(dependencyGraphs, (String)"dependencyGraphs");
        this.projects = projects2;
        this.packages = packages2;
        this.issues = issues;
        this.dependencyGraphs = dependencyGraphs;
    }

    public /* synthetic */ AnalyzerResult(Set set, Set set2, Map map, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(set, set2, map, map2);
    }

    @NotNull
    public final Set<Project> getProjects() {
        return this.projects;
    }

    @NotNull
    public final Set<Package> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Map<Identifier, List<Issue>> getIssues() {
        return this.issues;
    }

    @NotNull
    public final Map<String, DependencyGraph> getDependencyGraphs() {
        return this.dependencyGraphs;
    }

    /*
     * WARNING - void declaration
     */
    @JsonIgnore
    @NotNull
    public final Map<Identifier, Set<Issue>> getAllIssues() {
        Iterable $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterator<Map.Entry<Identifier, Set<Issue>>> it$iv$iv;
        Object object;
        Iterable $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        Map $this$getAllIssues_u24lambda_u248 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Map<Identifier, List<Issue>> map2 = this.issues;
        Map map3 = $this$getAllIssues_u24lambda_u248;
        boolean $i$f$mapValues = false;
        Iterator iterator = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv$iv = iterator2.next();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = object;
            boolean bl3 = false;
            Set set = CollectionsKt.toMutableSet((Iterable)((Iterable)it.getValue()));
            map4.put(k, set);
        }
        map3.putAll(destination$iv$iv);
        Iterable $this$filter$iv = this.projects;
        boolean $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Project it = (Project)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getScopeDependencies() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl5 = false;
            Set set = project.getScopeDependencies();
            if (set == null) {
                set = SetsKt.emptySet();
            }
            Sequence projectDependencies2 = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)getAllIssues.1.3.projectDependencies.1.INSTANCE));
            Map<Identifier, Set<Issue>> $this$forEach$iv2 = DependencyNavigator.Companion.collectIssues((Sequence<? extends DependencyNode>)projectDependencies2);
            boolean $i$f$forEach2 = false;
            it$iv$iv = $this$forEach$iv2.entrySet().iterator();
            while (it$iv$iv.hasNext()) {
                Object object2;
                Map.Entry<Identifier, Set<Issue>> element$iv2;
                Map.Entry<Identifier, Set<Issue>> bl2 = element$iv2 = it$iv$iv.next();
                boolean bl6 = false;
                Identifier id = bl2.getKey();
                Set<Issue> issues = bl2.getValue();
                Map $this$getOrPut$iv = $this$getAllIssues_u24lambda_u248;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(id);
                if (value$iv == null) {
                    boolean bl7 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(id, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                CollectionsKt.addAll((Collection)((Collection)object2), (Iterable)issues);
            }
        }
        $this$forEach$iv = this.dependencyGraphs.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyGraph graph = (DependencyGraph)element$iv;
            boolean bl8 = false;
            Map<Identifier, Set<Issue>> $this$forEach$iv3 = graph.collectIssues();
            boolean $i$f$forEach3 = false;
            for (Map.Entry<Identifier, Set<Issue>> element$iv3 : $this$forEach$iv3.entrySet()) {
                Object object3;
                object = element$iv3;
                boolean bl9 = false;
                Identifier id = (Identifier)object.getKey();
                Set issues = (Set)object.getValue();
                Map $this$getOrPut$iv = $this$getAllIssues_u24lambda_u248;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(id);
                if (value$iv == null) {
                    boolean bl10 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(id, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                CollectionsKt.addAll((Collection)((Collection)object3), (Iterable)issues);
            }
        }
        return MapsKt.build((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalyzerResult withResolvedScopes() {
        AnalyzerResult analyzerResult;
        if (!this.dependencyGraphs.isEmpty()) {
            void $this$mapTo$iv;
            Iterable iterable = this.projects;
            Collection collection = new LinkedHashSet();
            AnalyzerResult analyzerResult2 = this;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                void destination$iv;
                Project project = (Project)item$iv;
                void var9_9 = destination$iv;
                boolean bl = false;
                var9_9.add(it.withResolvedScopes(this.dependencyGraphs.get(it.getId().getType())));
            }
            analyzerResult = AnalyzerResult.copy$default(analyzerResult2, (Set)collection, null, null, MapsKt.emptyMap(), 6, null);
        } else {
            analyzerResult = this;
        }
        return analyzerResult;
    }

    @NotNull
    public final Set<Project> component1() {
        return this.projects;
    }

    @NotNull
    public final Set<Package> component2() {
        return this.packages;
    }

    @NotNull
    public final Map<Identifier, List<Issue>> component3() {
        return this.issues;
    }

    @NotNull
    public final Map<String, DependencyGraph> component4() {
        return this.dependencyGraphs;
    }

    @NotNull
    public final AnalyzerResult copy(@JsonSerialize(converter=ProjectSortedSetConverter.class) @NotNull Set<Project> projects2, @JsonSerialize(converter=PackageSortedSetConverter.class) @NotNull Set<Package> packages2, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<Identifier, ? extends List<Issue>> issues, @JsonInclude(value=JsonInclude.Include.NON_EMPTY) @NotNull Map<String, DependencyGraph> dependencyGraphs) {
        Intrinsics.checkNotNullParameter(projects2, (String)"projects");
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        Intrinsics.checkNotNullParameter(dependencyGraphs, (String)"dependencyGraphs");
        return new AnalyzerResult(projects2, packages2, issues, dependencyGraphs);
    }

    public static /* synthetic */ AnalyzerResult copy$default(AnalyzerResult analyzerResult, Set set, Set set2, Map map, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            set = analyzerResult.projects;
        }
        if ((n & 2) != 0) {
            set2 = analyzerResult.packages;
        }
        if ((n & 4) != 0) {
            map = analyzerResult.issues;
        }
        if ((n & 8) != 0) {
            map2 = analyzerResult.dependencyGraphs;
        }
        return analyzerResult.copy(set, set2, map, map2);
    }

    @NotNull
    public String toString() {
        return "AnalyzerResult(projects=" + this.projects + ", packages=" + this.packages + ", issues=" + this.issues + ", dependencyGraphs=" + this.dependencyGraphs + ")";
    }

    public int hashCode() {
        int result = ((Object)this.projects).hashCode();
        result = result * 31 + ((Object)this.packages).hashCode();
        result = result * 31 + ((Object)this.issues).hashCode();
        result = result * 31 + ((Object)this.dependencyGraphs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnalyzerResult)) {
            return false;
        }
        AnalyzerResult analyzerResult = (AnalyzerResult)other;
        if (!Intrinsics.areEqual(this.projects, analyzerResult.projects)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.packages, analyzerResult.packages)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.issues, analyzerResult.issues)) {
            return false;
        }
        return Intrinsics.areEqual(this.dependencyGraphs, analyzerResult.dependencyGraphs);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/ossreviewtoolkit/model/AnalyzerResult$Companion;", "", "()V", "EMPTY", "Lorg/ossreviewtoolkit/model/AnalyzerResult;", "model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

