/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.AnalyzerResult;
import org.ossreviewtoolkit.model.AnalyzerRun;
import org.ossreviewtoolkit.model.CompatibilityDependencyNavigator;
import org.ossreviewtoolkit.model.CompatibilityDependencyNavigatorKt;
import org.ossreviewtoolkit.model.DependencyGraphNavigator;
import org.ossreviewtoolkit.model.DependencyNavigator;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.DependencyTreeNavigator;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.Project;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J>\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u0002`\u0015H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J>\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u0002`\u0015H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J6\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c*\u00020\f2\u001d\u0010\u001d\u001a\u0019\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u0002H\u001c0\u001e\u00a2\u0006\u0002\b\u001fH\u0002\u00a2\u0006\u0002\u0010 R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/ossreviewtoolkit/model/CompatibilityDependencyNavigator;", "Lorg/ossreviewtoolkit/model/DependencyNavigator;", "graphNavigator", "treeNavigator", "(Lorg/ossreviewtoolkit/model/DependencyNavigator;Lorg/ossreviewtoolkit/model/DependencyNavigator;)V", "getGraphNavigator", "()Lorg/ossreviewtoolkit/model/DependencyNavigator;", "getTreeNavigator", "dependenciesForScope", "", "Lorg/ossreviewtoolkit/model/Identifier;", "project", "Lorg/ossreviewtoolkit/model/Project;", "scopeName", "", "maxDepth", "", "matcher", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/DependencyNode;", "", "Lorg/ossreviewtoolkit/model/DependencyMatcher;", "directDependencies", "Lkotlin/sequences/Sequence;", "packageDependencies", "packageId", "scopeNames", "invokeNavigator", "T", "block", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lorg/ossreviewtoolkit/model/Project;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "Companion", "model"})
public final class CompatibilityDependencyNavigator
implements DependencyNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DependencyNavigator graphNavigator;
    @NotNull
    private final DependencyNavigator treeNavigator;

    public CompatibilityDependencyNavigator(@NotNull DependencyNavigator graphNavigator, @NotNull DependencyNavigator treeNavigator) {
        Intrinsics.checkNotNullParameter((Object)graphNavigator, (String)"graphNavigator");
        Intrinsics.checkNotNullParameter((Object)treeNavigator, (String)"treeNavigator");
        this.graphNavigator = graphNavigator;
        this.treeNavigator = treeNavigator;
    }

    @NotNull
    public final DependencyNavigator getGraphNavigator() {
        return this.graphNavigator;
    }

    @NotNull
    public final DependencyNavigator getTreeNavigator() {
        return this.treeNavigator;
    }

    @Override
    @NotNull
    public Set<String> scopeNames(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Set)this.invokeNavigator(project, scopeNames.1.INSTANCE);
    }

    @Override
    @NotNull
    public Sequence<DependencyNode> directDependencies(@NotNull Project project, @NotNull String scopeName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        return (Sequence)this.invokeNavigator(project, (Function2)new Function2<DependencyNavigator, Project, Sequence<? extends DependencyNode>>(scopeName){
            final /* synthetic */ String $scopeName;
            {
                this.$scopeName = $scopeName;
                super(2);
            }

            @NotNull
            public final Sequence<DependencyNode> invoke(@NotNull DependencyNavigator $this$invokeNavigator, @NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)$this$invokeNavigator, (String)"$this$invokeNavigator");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $this$invokeNavigator.directDependencies(it, this.$scopeName);
            }
        });
    }

    @Override
    @NotNull
    public Set<Identifier> dependenciesForScope(@NotNull Project project, @NotNull String scopeName, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        return (Set)this.invokeNavigator(project, (Function2)new Function2<DependencyNavigator, Project, Set<? extends Identifier>>(scopeName, maxDepth, matcher2){
            final /* synthetic */ String $scopeName;
            final /* synthetic */ int $maxDepth;
            final /* synthetic */ Function1<DependencyNode, Boolean> $matcher;
            {
                this.$scopeName = $scopeName;
                this.$maxDepth = $maxDepth;
                this.$matcher = $matcher;
                super(2);
            }

            @NotNull
            public final Set<Identifier> invoke(@NotNull DependencyNavigator $this$invokeNavigator, @NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)$this$invokeNavigator, (String)"$this$invokeNavigator");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $this$invokeNavigator.dependenciesForScope(it, this.$scopeName, this.$maxDepth, this.$matcher);
            }
        });
    }

    @Override
    @NotNull
    public Set<Identifier> packageDependencies(@NotNull Project project, @NotNull Identifier packageId, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        return (Set)this.invokeNavigator(project, (Function2)new Function2<DependencyNavigator, Project, Set<? extends Identifier>>(packageId, maxDepth, matcher2){
            final /* synthetic */ Identifier $packageId;
            final /* synthetic */ int $maxDepth;
            final /* synthetic */ Function1<DependencyNode, Boolean> $matcher;
            {
                this.$packageId = $packageId;
                this.$maxDepth = $maxDepth;
                this.$matcher = $matcher;
                super(2);
            }

            @NotNull
            public final Set<Identifier> invoke(@NotNull DependencyNavigator $this$invokeNavigator, @NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)$this$invokeNavigator, (String)"$this$invokeNavigator");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $this$invokeNavigator.packageDependencies(it, this.$packageId, this.$maxDepth, this.$matcher);
            }
        });
    }

    private final <T> T invokeNavigator(Project $this$invokeNavigator, Function2<? super DependencyNavigator, ? super Project, ? extends T> block) {
        DependencyNavigator navigator = CompatibilityDependencyNavigatorKt.access$usesTree($this$invokeNavigator) ? this.treeNavigator : this.graphNavigator;
        return (T)block.invoke((Object)navigator, (Object)$this$invokeNavigator);
    }

    @Override
    @NotNull
    public Map<String, Set<Identifier>> scopeDependencies(@NotNull Project project, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        return DependencyNavigator.DefaultImpls.scopeDependencies(this, project, maxDepth, matcher2);
    }

    @Override
    @NotNull
    public Map<String, Map<Identifier, List<Identifier>>> getShortestPaths(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.getShortestPaths(this, project);
    }

    @Override
    @NotNull
    public Set<Identifier> collectSubProjects(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.collectSubProjects(this, project);
    }

    @Override
    @NotNull
    public Set<Identifier> projectDependencies(@NotNull Project project, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        return DependencyNavigator.DefaultImpls.projectDependencies(this, project, maxDepth, matcher2);
    }

    @Override
    public int dependencyTreeDepth(@NotNull Project project, @NotNull String scopeName) {
        return DependencyNavigator.DefaultImpls.dependencyTreeDepth(this, project, scopeName);
    }

    @Override
    @NotNull
    public Map<Identifier, Set<Issue>> projectIssues(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.projectIssues(this, project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/ossreviewtoolkit/model/CompatibilityDependencyNavigator$Companion;", "", "()V", "create", "Lorg/ossreviewtoolkit/model/DependencyNavigator;", "ortResult", "Lorg/ossreviewtoolkit/model/OrtResult;", "model"})
    @SourceDebugExtension(value={"SMAP\nCompatibilityDependencyNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompatibilityDependencyNavigator.kt\norg/ossreviewtoolkit/model/CompatibilityDependencyNavigator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n3190#2,10:99\n*S KotlinDebug\n*F\n+ 1 CompatibilityDependencyNavigator.kt\norg/ossreviewtoolkit/model/CompatibilityDependencyNavigator$Companion\n*L\n52#1:99,10\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DependencyNavigator create(@NotNull OrtResult ortResult) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)ortResult, (String)"ortResult");
            Object object = ortResult.getAnalyzer();
            if ((object != null && (object = ((AnalyzerRun)object).getResult()) != null ? ((AnalyzerResult)object).getDependencyGraphs() : (map = null)) == null) {
                map = MapsKt.emptyMap();
            }
            if (map.isEmpty()) {
                return DependencyTreeNavigator.INSTANCE;
            }
            Iterable $this$partition$iv = OrtResult.getProjects$default(ortResult, false, false, 3, null);
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                Project p0 = (Project)element$iv;
                boolean bl = false;
                if (CompatibilityDependencyNavigatorKt.access$usesTree(p0)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List treeProjects = (List)pair.component1();
            List graphProjects = (List)pair.component2();
            return !((Collection)graphProjects).isEmpty() && !((Collection)treeProjects).isEmpty() ? (DependencyNavigator)new CompatibilityDependencyNavigator(new DependencyGraphNavigator(ortResult), DependencyTreeNavigator.INSTANCE) : (graphProjects.isEmpty() ? (DependencyNavigator)DependencyTreeNavigator.INSTANCE : (DependencyNavigator)new DependencyGraphNavigator(ortResult));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

