/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.DependencyGraph;
import org.ossreviewtoolkit.model.DependencyGraphEdge;
import org.ossreviewtoolkit.model.DependencyGraphKt;
import org.ossreviewtoolkit.model.DependencyGraphNode;
import org.ossreviewtoolkit.model.DependencyReference;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.PackageLinkage;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.RootDependencyIndex;
import org.ossreviewtoolkit.model.Scope;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 =2\u00020\u0001:\u0001=Be\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\t\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0#0\tJ\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\u001b\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\tH\u00c6\u0003J\u0011\u0010(\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010)\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003H\u00c6\u0003J\u001e\u0010*\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00030\tj\u0002`\u0012H\u0002J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\tH\u0002J$\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\r2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0/H\u0002Ji\u00100\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\t2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00032\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003H\u00c6\u0001J\f\u00101\u001a\b\u0012\u0004\u0012\u0002020#J$\u00101\u001a\b\u0012\u0004\u0012\u0002020#2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\n0#2\b\b\u0002\u00104\u001a\u000205J0\u00106\u001a\b\u0012\u0004\u0012\u0002020#2\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\t2\u0006\u00104\u001a\u000205H\u0002J\u0013\u00108\u001a\u0002052\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020\nH\u00d6\u0001R1\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00030\tj\u0002`\u00128GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R'\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0016\u001a\u0004\b\u001d\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014\u00a8\u0006>"}, d2={"Lorg/ossreviewtoolkit/model/DependencyGraph;", "", "packages", "", "Lorg/ossreviewtoolkit/model/Identifier;", "scopeRoots", "Ljava/util/SortedSet;", "Lorg/ossreviewtoolkit/model/DependencyReference;", "scopes", "", "", "Lorg/ossreviewtoolkit/model/RootDependencyIndex;", "nodes", "Lorg/ossreviewtoolkit/model/DependencyGraphNode;", "edges", "Lorg/ossreviewtoolkit/model/DependencyGraphEdge;", "(Ljava/util/List;Ljava/util/SortedSet;Ljava/util/Map;Ljava/util/List;Ljava/util/List;)V", "dependencies", "Lorg/ossreviewtoolkit/model/NodeDependencies;", "getDependencies", "()Ljava/util/Map;", "dependencies$delegate", "Lkotlin/Lazy;", "getEdges", "()Ljava/util/List;", "getNodes", "getPackages", "referenceMapping", "Lorg/ossreviewtoolkit/model/PackageReference;", "getReferenceMapping", "referenceMapping$delegate", "getScopeRoots", "()Ljava/util/SortedSet;", "getScopes", "collectIssues", "", "Lorg/ossreviewtoolkit/model/Issue;", "component1", "component2", "component3", "component4", "component5", "constructNodeDependencies", "constructReferenceMapping", "constructReferenceTree", "node", "refMapping", "", "copy", "createScopes", "Lorg/ossreviewtoolkit/model/Scope;", "scopeNames", "unqualify", "", "createScopesFor", "map", "equals", "other", "hashCode", "", "toString", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nDependencyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyGraph.kt\norg/ossreviewtoolkit/model/DependencyGraph\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,438:1\n478#2,7:439\n372#2,3:458\n375#2,4:464\n372#2,7:470\n152#3,2:446\n154#3:451\n1620#4,3:448\n1549#4:452\n1620#4,3:453\n1855#4,2:456\n1620#4,3:461\n1855#4,2:468\n1855#4,2:477\n*S KotlinDebug\n*F\n+ 1 DependencyGraph.kt\norg/ossreviewtoolkit/model/DependencyGraph\n*L\n164#1:439,7\n202#1:458,3\n202#1:464,4\n233#1:470,7\n171#1:446,2\n171#1:451\n172#1:448,3\n186#1:452\n186#1:453,3\n188#1:456,2\n203#1:461,3\n246#1:468,2\n239#1:477,2\n*E\n"})
public final class DependencyGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Identifier> packages;
    @NotNull
    private final SortedSet<DependencyReference> scopeRoots;
    @NotNull
    private final Map<String, List<RootDependencyIndex>> scopes;
    @Nullable
    private final List<DependencyGraphNode> nodes;
    @Nullable
    private final List<DependencyGraphEdge> edges;
    @NotNull
    private final Lazy dependencies$delegate;
    @NotNull
    private final Lazy referenceMapping$delegate;
    @NotNull
    private static final Comparator<DependencyReference> DEPENDENCY_REFERENCE_COMPARATOR;

    public DependencyGraph(@NotNull List<Identifier> packages2, @NotNull SortedSet<DependencyReference> scopeRoots, @NotNull Map<String, ? extends List<RootDependencyIndex>> scopes2, @Nullable List<DependencyGraphNode> nodes, @Nullable List<DependencyGraphEdge> edges) {
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(scopeRoots, (String)"scopeRoots");
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        this.packages = packages2;
        this.scopeRoots = scopeRoots;
        this.scopes = scopes2;
        this.nodes = nodes;
        this.edges = edges;
        this.dependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<DependencyGraphNode, ? extends List<? extends DependencyGraphNode>>>(this){
            final /* synthetic */ DependencyGraph this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<DependencyGraphNode, List<DependencyGraphNode>> invoke() {
                return DependencyGraph.access$constructNodeDependencies(this.this$0);
            }
        }));
        this.referenceMapping$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends PackageReference>>(this){
            final /* synthetic */ DependencyGraph this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, PackageReference> invoke() {
                return DependencyGraph.access$constructReferenceMapping(this.this$0);
            }
        }));
    }

    public /* synthetic */ DependencyGraph(List list, SortedSet sortedSet, Map map, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            sortedSet = SetsKt.sortedSetOf((Object[])new DependencyReference[0]);
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            list3 = null;
        }
        this(list, sortedSet, map, list2, list3);
    }

    @NotNull
    public final List<Identifier> getPackages() {
        return this.packages;
    }

    @NotNull
    public final SortedSet<DependencyReference> getScopeRoots() {
        return this.scopeRoots;
    }

    @NotNull
    public final Map<String, List<RootDependencyIndex>> getScopes() {
        return this.scopes;
    }

    @Nullable
    public final List<DependencyGraphNode> getNodes() {
        return this.nodes;
    }

    @Nullable
    public final List<DependencyGraphEdge> getEdges() {
        return this.edges;
    }

    @JsonIgnore
    @NotNull
    public final Map<DependencyGraphNode, List<DependencyGraphNode>> getDependencies() {
        Lazy lazy = this.dependencies$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, PackageReference> getReferenceMapping() {
        Lazy lazy = this.referenceMapping$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Set<Scope> createScopes() {
        return this.createScopesFor(this.scopes, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Scope> createScopes(@NotNull Set<String> scopeNames2, boolean unqualify) {
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter(scopeNames2, (String)"scopeNames");
        Map<String, List<RootDependencyIndex>> map = this.scopes;
        DependencyGraph dependencyGraph = this;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!scopeNames2.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return dependencyGraph.createScopesFor(result$iv, unqualify);
    }

    public static /* synthetic */ Set createScopes$default(DependencyGraph dependencyGraph, Set set, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return dependencyGraph.createScopes(set, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Scope> createScopesFor(Map<String, ? extends List<RootDependencyIndex>> map, boolean unqualify) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, ? extends List<RootDependencyIndex>> map2 = map;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void destination$iv2;
            void $this$mapTo$iv2;
            void entry;
            Map.Entry item$iv;
            Map.Entry entry2 = item$iv = iterator.next();
            void var19_19 = destination$iv;
            boolean bl = false;
            Iterable iterable = (Iterable)entry.getValue();
            Collection collection2 = new LinkedHashSet();
            boolean $i$f$mapTo2 = false;
            for (Object item$iv2 : $this$mapTo$iv2) {
                void index;
                RootDependencyIndex rootDependencyIndex = (RootDependencyIndex)item$iv2;
                void var16_16 = destination$iv2;
                boolean bl2 = false;
                PackageReference packageReference = this.getReferenceMapping().get(index.toKey());
                if (packageReference == null) {
                    throw new IllegalStateException(("Could not resolve dependency index " + (RootDependencyIndex)index + ".").toString());
                }
                var16_16.add(packageReference);
            }
            Set dependencies2 = (Set)destination$iv2;
            String scopeName = unqualify ? Companion.unqualifyScope((String)entry.getKey()) : (String)entry.getKey();
            var19_19.add(new Scope(scopeName, dependencies2));
        }
        return (Set)destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PackageReference> constructReferenceMapping() {
        Map refMapping = new LinkedHashMap();
        List list = this.nodes;
        if (list == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.scopeRoots;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                DependencyReference dependencyReference = (DependencyReference)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DependencyGraphKt.access$toGraphNode((DependencyReference)p0));
            }
            list = (List)destination$iv$iv;
        }
        List allNodes = list;
        Iterable $this$forEach$iv = allNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyGraphNode it = (DependencyGraphNode)element$iv;
            boolean bl = false;
            this.constructReferenceTree(it, refMapping);
        }
        return refMapping;
    }

    /*
     * WARNING - void declaration
     */
    private final PackageReference constructReferenceTree(DependencyGraphNode node, Map<String, PackageReference> refMapping) {
        PackageReference packageReference;
        String indexKey = RootDependencyIndex.Companion.generateKey(node.getPkg(), node.getFragment());
        Map<String, PackageReference> $this$getOrPut$iv = refMapping;
        boolean $i$f$getOrPut = false;
        PackageReference value$iv = $this$getOrPut$iv.get(indexKey);
        if (value$iv == null) {
            void destination$iv;
            void $this$mapTo$iv;
            boolean bl = false;
            List list = this.getDependencies().get(node);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Object object = list;
            Object object2 = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                DependencyGraphNode dependencyGraphNode = (DependencyGraphNode)item$iv;
                void var14_15 = destination$iv;
                boolean bl2 = false;
                var14_15.add(this.constructReferenceTree((DependencyGraphNode)it, refMapping));
            }
            Set refDependencies = (Set)destination$iv;
            object = this.packages.get(node.getPkg());
            object2 = node.getLinkage();
            List<Issue> list2 = node.getIssues();
            PackageReference answer$iv = new PackageReference((Identifier)object, (PackageLinkage)((Object)object2), refDependencies, list2);
            $this$getOrPut$iv.put(indexKey, answer$iv);
            packageReference = answer$iv;
        } else {
            packageReference = value$iv;
        }
        return packageReference;
    }

    private final Map<DependencyGraphNode, List<DependencyGraphNode>> constructNodeDependencies() {
        return this.nodes != null && this.edges != null ? DependencyGraphKt.access$constructNodeDependenciesFromGraph(this.nodes, this.edges) : DependencyGraphKt.access$constructNodeDependenciesFromScopeRoots(this.scopeRoots);
    }

    @NotNull
    public final Map<Identifier, Set<Issue>> collectIssues() {
        Map collectedIssues;
        block2: {
            collectedIssues = new LinkedHashMap();
            for (DependencyReference ref : this.scopeRoots) {
                Intrinsics.checkNotNull((Object)ref);
                DependencyGraph.collectIssues$addIssues$8(collectedIssues, this, ref);
            }
            List<DependencyGraphNode> list = this.nodes;
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DependencyGraphNode node = (DependencyGraphNode)element$iv;
                boolean bl = false;
                DependencyGraph.collectIssues$addIssues(collectedIssues, this, node.getPkg(), (Collection<Issue>)node.getIssues());
            }
        }
        return collectedIssues;
    }

    @NotNull
    public final List<Identifier> component1() {
        return this.packages;
    }

    @NotNull
    public final SortedSet<DependencyReference> component2() {
        return this.scopeRoots;
    }

    @NotNull
    public final Map<String, List<RootDependencyIndex>> component3() {
        return this.scopes;
    }

    @Nullable
    public final List<DependencyGraphNode> component4() {
        return this.nodes;
    }

    @Nullable
    public final List<DependencyGraphEdge> component5() {
        return this.edges;
    }

    @NotNull
    public final DependencyGraph copy(@NotNull List<Identifier> packages2, @NotNull SortedSet<DependencyReference> scopeRoots, @NotNull Map<String, ? extends List<RootDependencyIndex>> scopes2, @Nullable List<DependencyGraphNode> nodes, @Nullable List<DependencyGraphEdge> edges) {
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        Intrinsics.checkNotNullParameter(scopeRoots, (String)"scopeRoots");
        Intrinsics.checkNotNullParameter(scopes2, (String)"scopes");
        return new DependencyGraph(packages2, scopeRoots, scopes2, nodes, edges);
    }

    public static /* synthetic */ DependencyGraph copy$default(DependencyGraph dependencyGraph, List list, SortedSet sortedSet, Map map, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list = dependencyGraph.packages;
        }
        if ((n & 2) != 0) {
            sortedSet = dependencyGraph.scopeRoots;
        }
        if ((n & 4) != 0) {
            map = dependencyGraph.scopes;
        }
        if ((n & 8) != 0) {
            list2 = dependencyGraph.nodes;
        }
        if ((n & 0x10) != 0) {
            list3 = dependencyGraph.edges;
        }
        return dependencyGraph.copy(list, sortedSet, map, list2, list3);
    }

    @NotNull
    public String toString() {
        return "DependencyGraph(packages=" + this.packages + ", scopeRoots=" + this.scopeRoots + ", scopes=" + this.scopes + ", nodes=" + this.nodes + ", edges=" + this.edges + ")";
    }

    public int hashCode() {
        int result = ((Object)this.packages).hashCode();
        result = result * 31 + this.scopeRoots.hashCode();
        result = result * 31 + ((Object)this.scopes).hashCode();
        result = result * 31 + (this.nodes == null ? 0 : ((Object)this.nodes).hashCode());
        result = result * 31 + (this.edges == null ? 0 : ((Object)this.edges).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependencyGraph)) {
            return false;
        }
        DependencyGraph dependencyGraph = (DependencyGraph)other;
        if (!Intrinsics.areEqual(this.packages, dependencyGraph.packages)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scopeRoots, dependencyGraph.scopeRoots)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.scopes, dependencyGraph.scopes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.nodes, dependencyGraph.nodes)) {
            return false;
        }
        return Intrinsics.areEqual(this.edges, dependencyGraph.edges);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectIssues$addIssues(Map<Identifier, Set<Issue>> collectedIssues, DependencyGraph this$0, int pkg, Collection<Issue> issues) {
        if (!issues.isEmpty()) {
            Object object;
            void $this$getOrPut$iv;
            Map<Identifier, Set<Issue>> map = collectedIssues;
            Identifier key$iv = this$0.packages.get(pkg);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            CollectionsKt.addAll((Collection)((Collection)object), (Iterable)issues);
        }
    }

    private static final void collectIssues$addIssues$8(Map<Identifier, Set<Issue>> collectedIssues, DependencyGraph this$0, DependencyReference ref) {
        DependencyGraph.collectIssues$addIssues(collectedIssues, this$0, ref.getPkg(), (Collection<Issue>)ref.getIssues());
        Iterable $this$forEach$iv = ref.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DependencyReference it = (DependencyReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            DependencyGraph.collectIssues$addIssues$8(collectedIssues, this$0, it);
        }
    }

    public DependencyGraph() {
        this(null, null, null, null, null, 31, null);
    }

    public static final /* synthetic */ Map access$constructNodeDependencies(DependencyGraph $this) {
        return $this.constructNodeDependencies();
    }

    public static final /* synthetic */ Map access$constructReferenceMapping(DependencyGraph $this) {
        return $this.constructReferenceMapping();
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.DEPENDENCY_REFERENCE_COMPARATOR.1.INSTANCE, Companion.DEPENDENCY_REFERENCE_COMPARATOR.2.INSTANCE};
        DEPENDENCY_REFERENCE_COMPARATOR = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nR!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/ossreviewtoolkit/model/DependencyGraph$Companion;", "", "()V", "DEPENDENCY_REFERENCE_COMPARATOR", "Ljava/util/Comparator;", "Lorg/ossreviewtoolkit/model/DependencyReference;", "Lkotlin/Comparator;", "getDEPENDENCY_REFERENCE_COMPARATOR", "()Ljava/util/Comparator;", "qualifyScope", "", "projectId", "Lorg/ossreviewtoolkit/model/Identifier;", "scopeName", "project", "Lorg/ossreviewtoolkit/model/Project;", "unqualifyScope", "model"})
    @SourceDebugExtension(value={"SMAP\nDependencyGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyGraph.kt\norg/ossreviewtoolkit/model/DependencyGraph$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n1#2:439\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<DependencyReference> getDEPENDENCY_REFERENCE_COMPARATOR() {
            return DEPENDENCY_REFERENCE_COMPARATOR;
        }

        @NotNull
        public final String qualifyScope(@NotNull Project project, @NotNull String scopeName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
            return this.qualifyScope(project.getId(), scopeName);
        }

        @NotNull
        public final String qualifyScope(@NotNull Identifier projectId, @NotNull String scopeName) {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
            return projectId.getNamespace() + ":" + projectId.getName() + ":" + projectId.getVersion() + ":" + scopeName;
        }

        @NotNull
        public final String unqualifyScope(@NotNull String scopeName) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
            Object object2 = new char[]{':'};
            object2 = StringsKt.split$default((CharSequence)scopeName, (char[])object2, (boolean)false, (int)4, (int)2, null);
            int n = 3;
            if (n <= CollectionsKt.getLastIndex((List)object2)) {
                object = object2.get(n);
            } else {
                int it = n;
                boolean bl = false;
                object = scopeName;
            }
            return (String)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

