/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.AnalyzerResult;
import org.ossreviewtoolkit.model.AnalyzerRun;
import org.ossreviewtoolkit.model.DependencyGraph;
import org.ossreviewtoolkit.model.DependencyGraphNavigatorKt;
import org.ossreviewtoolkit.model.DependencyGraphNode;
import org.ossreviewtoolkit.model.DependencyNavigator;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.OrtResult;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.RootDependencyIndex;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ>\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bj\u0002`\u001eH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u0007H\u0002J>\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bj\u0002`\u001eH\u0016J \u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0002J\u0018\u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R3\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/ossreviewtoolkit/model/DependencyGraphNavigator;", "Lorg/ossreviewtoolkit/model/DependencyNavigator;", "ortResult", "Lorg/ossreviewtoolkit/model/OrtResult;", "(Lorg/ossreviewtoolkit/model/OrtResult;)V", "graphs", "", "", "Lorg/ossreviewtoolkit/model/DependencyGraph;", "(Ljava/util/Map;)V", "graphDependencyRefMappings", "", "", "Lorg/ossreviewtoolkit/model/DependencyGraphNode;", "getGraphDependencyRefMappings", "()Ljava/util/Map;", "graphDependencyRefMappings$delegate", "Lkotlin/Lazy;", "dependenciesForScope", "", "Lorg/ossreviewtoolkit/model/Identifier;", "project", "Lorg/ossreviewtoolkit/model/Project;", "scopeName", "maxDepth", "", "matcher", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/DependencyNode;", "", "Lorg/ossreviewtoolkit/model/DependencyMatcher;", "directDependencies", "Lkotlin/sequences/Sequence;", "graphForManager", "manager", "packageDependencies", "packageId", "referenceFor", "pkgIndex", "fragment", "rootIndex", "Lorg/ossreviewtoolkit/model/RootDependencyIndex;", "scopeNames", "model"})
@SourceDebugExtension(value={"SMAP\nDependencyGraphNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyGraphNavigator.kt\norg/ossreviewtoolkit/model/DependencyGraphNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,247:1\n1549#2:248\n1620#2,3:249\n1855#2:252\n1856#2:255\n1313#3,2:253\n1#4:256\n*S KotlinDebug\n*F\n+ 1 DependencyGraphNavigator.kt\norg/ossreviewtoolkit/model/DependencyGraphNavigator\n*L\n49#1:248\n49#1:249,3\n85#1:252\n85#1:255\n86#1:253,2\n*E\n"})
public final class DependencyGraphNavigator
implements DependencyNavigator {
    @NotNull
    private final Map<String, DependencyGraph> graphs;
    @NotNull
    private final Lazy graphDependencyRefMappings$delegate;

    public DependencyGraphNavigator(@NotNull Map<String, DependencyGraph> graphs) {
        Intrinsics.checkNotNullParameter(graphs, (String)"graphs");
        this.graphs = graphs;
        if (!(!this.graphs.isEmpty())) {
            boolean bl = false;
            String string = "No dependency graph available to initialize DependencyGraphNavigator.";
            throw new IllegalArgumentException(string.toString());
        }
        this.graphDependencyRefMappings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends List<DependencyGraphNode>[]>>(this){
            final /* synthetic */ DependencyGraphNavigator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, List<DependencyGraphNode>[]> invoke() {
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv = DependencyGraphNavigator.access$getGraphs$p(this.this$0);
                boolean $i$f$mapValues = false;
                Map map = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl2 = false;
                    List[] listArray = DependencyGraphNavigatorKt.access$dependencyRefMapping((DependencyGraph)it.getValue());
                    map3.put(k, listArray);
                }
                return destination$iv$iv;
            }
        }));
    }

    public DependencyGraphNavigator(@NotNull OrtResult ortResult) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)ortResult, (String)"ortResult");
        Object object = ortResult.getAnalyzer();
        if ((object != null && (object = ((AnalyzerRun)object).getResult()) != null ? ((AnalyzerResult)object).getDependencyGraphs() : (map = null)) == null) {
            map = MapsKt.emptyMap();
        }
        this(map);
    }

    private final Map<String, List<DependencyGraphNode>[]> getGraphDependencyRefMappings() {
        Lazy lazy = this.graphDependencyRefMappings$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<String> scopeNames(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set set = project.getScopeNames();
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<DependencyNode> directDependencies(@NotNull Project project, @NotNull String scopeName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        DependencyGraph graph = this.graphForManager(DependencyGraphNavigatorKt.access$getManagerName(project));
        List list = graph.getScopes().get(DependencyGraph.Companion.qualifyScope(project, scopeName));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void root;
            RootDependencyIndex rootDependencyIndex = (RootDependencyIndex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.referenceFor(DependencyGraphNavigatorKt.access$getManagerName(project), (RootDependencyIndex)root));
        }
        List rootDependencies = (List)destination$iv$iv;
        return DependencyGraphNavigatorKt.access$dependenciesSequence(graph, rootDependencies);
    }

    @Override
    @NotNull
    public Set<Identifier> dependenciesForScope(@NotNull Project project, @NotNull String scopeName, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        Set dependencyIds = new LinkedHashSet();
        DependencyGraphNavigatorKt.collectDependencies$default(this.directDependencies(project, scopeName), maxDepth, matcher2, dependencyIds, null, 16, null);
        return dependencyIds;
    }

    @Override
    @NotNull
    public Set<Identifier> packageDependencies(@NotNull Project project, @NotNull Identifier packageId, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        Set dependencies2 = new LinkedHashSet();
        Iterable $this$forEach$iv = this.scopeNames(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String scope = (String)element$iv;
            boolean bl = false;
            Sequence<DependencyNode> $this$forEach$iv2 = this.directDependencies(project, scope);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DependencyNode p0 = (DependencyNode)element$iv2;
                boolean bl2 = false;
                DependencyGraphNavigator.packageDependencies$traverse(packageId, maxDepth, matcher2, dependencies2, p0);
            }
        }
        return dependencies2;
    }

    private final DependencyGraph graphForManager(String manager) {
        DependencyGraph dependencyGraph = this.graphs.get(manager);
        if (dependencyGraph == null) {
            boolean bl = false;
            String string = "No DependencyGraph for package manager '" + manager + "' available.";
            throw new IllegalArgumentException(string.toString());
        }
        return dependencyGraph;
    }

    private final DependencyGraphNode referenceFor(String manager, int pkgIndex, int fragment) {
        Object v1;
        block3: {
            List<DependencyGraphNode>[] listArray = this.getGraphDependencyRefMappings().get(manager);
            if (listArray == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterable iterable = listArray[pkgIndex];
            for (Object t : iterable) {
                DependencyGraphNode it = (DependencyGraphNode)t;
                boolean bl = false;
                if (!(it.getFragment() == fragment)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        DependencyGraphNode dependencyGraphNode = v1;
        if (dependencyGraphNode == null) {
            throw new IllegalArgumentException("Could not resolve a DependencyReference for index = " + pkgIndex + " and fragment " + fragment + ".");
        }
        return dependencyGraphNode;
    }

    private final DependencyGraphNode referenceFor(String manager, RootDependencyIndex rootIndex) {
        return this.referenceFor(manager, rootIndex.getRoot(), rootIndex.getFragment());
    }

    @Override
    @NotNull
    public Map<String, Set<Identifier>> scopeDependencies(@NotNull Project project, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        return DependencyNavigator.DefaultImpls.scopeDependencies(this, project, maxDepth, matcher2);
    }

    @Override
    @NotNull
    public Map<String, Map<Identifier, List<Identifier>>> getShortestPaths(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.getShortestPaths(this, project);
    }

    @Override
    @NotNull
    public Set<Identifier> collectSubProjects(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.collectSubProjects(this, project);
    }

    @Override
    @NotNull
    public Set<Identifier> projectDependencies(@NotNull Project project, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        return DependencyNavigator.DefaultImpls.projectDependencies(this, project, maxDepth, matcher2);
    }

    @Override
    public int dependencyTreeDepth(@NotNull Project project, @NotNull String scopeName) {
        return DependencyNavigator.DefaultImpls.dependencyTreeDepth(this, project, scopeName);
    }

    @Override
    @NotNull
    public Map<Identifier, Set<Issue>> projectIssues(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.projectIssues(this, project);
    }

    private static final void packageDependencies$traverse(Identifier $packageId, int $maxDepth, Function1<? super DependencyNode, Boolean> $matcher, Set<Identifier> dependencies2, DependencyNode node) {
        if (Intrinsics.areEqual((Object)node.getId(), (Object)$packageId)) {
            node.visitDependencies((Function1)new Function1<Sequence<? extends DependencyNode>, Unit>($maxDepth, $matcher, dependencies2){
                final /* synthetic */ int $maxDepth;
                final /* synthetic */ Function1<DependencyNode, Boolean> $matcher;
                final /* synthetic */ Set<Identifier> $dependencies;
                {
                    this.$maxDepth = $maxDepth;
                    this.$matcher = $matcher;
                    this.$dependencies = $dependencies;
                    super(1);
                }

                public final void invoke(@NotNull Sequence<? extends DependencyNode> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    DependencyGraphNavigatorKt.collectDependencies$default(it, this.$maxDepth, this.$matcher, this.$dependencies, null, 16, null);
                }
            });
        }
        node.visitDependencies((Function1)new Function1<Sequence<? extends DependencyNode>, Unit>($packageId, $maxDepth, $matcher, dependencies2){
            final /* synthetic */ Identifier $packageId;
            final /* synthetic */ int $maxDepth;
            final /* synthetic */ Function1<DependencyNode, Boolean> $matcher;
            final /* synthetic */ Set<Identifier> $dependencies;
            {
                this.$packageId = $packageId;
                this.$maxDepth = $maxDepth;
                this.$matcher = $matcher;
                this.$dependencies = $dependencies;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Sequence<? extends DependencyNode> dependencies2) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
                Sequence<? extends DependencyNode> sequence = dependencies2;
                Identifier identifier = this.$packageId;
                int n = this.$maxDepth;
                Function1<DependencyNode, Boolean> function1 = this.$matcher;
                Set<Identifier> set = this.$dependencies;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    DependencyNode p0 = (DependencyNode)element$iv;
                    boolean bl = false;
                    DependencyGraphNavigator.access$packageDependencies$traverse(identifier, n, function1, set, p0);
                }
            }
        });
    }

    public static final /* synthetic */ void access$packageDependencies$traverse(Identifier $packageId, int $maxDepth, Function1 $matcher, Set dependencies2, DependencyNode node) {
        DependencyGraphNavigator.packageDependencies$traverse($packageId, $maxDepth, (Function1<? super DependencyNode, Boolean>)$matcher, dependencies2, node);
    }

    public static final /* synthetic */ Map access$getGraphs$p(DependencyGraphNavigator $this) {
        return $this.graphs;
    }
}

