/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.DependencyGraph;
import org.ossreviewtoolkit.model.DependencyGraphNavigatorKt;
import org.ossreviewtoolkit.model.DependencyGraphNode;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.PackageLinkage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020\u0001H\u0016J\b\u0010(\u001a\u00020)H\u0016J-\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0018\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010!\u0012\u0004\u0012\u0002H+0-H\u0016\u00a2\u0006\u0002\u0010.R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/ossreviewtoolkit/model/DependencyRefCursor;", "Lorg/ossreviewtoolkit/model/DependencyNode;", "graph", "Lorg/ossreviewtoolkit/model/DependencyGraph;", "nodes", "", "Lorg/ossreviewtoolkit/model/DependencyGraphNode;", "initCurrent", "(Lorg/ossreviewtoolkit/model/DependencyGraph;Ljava/util/Collection;Lorg/ossreviewtoolkit/model/DependencyGraphNode;)V", "current", "getCurrent", "()Lorg/ossreviewtoolkit/model/DependencyGraphNode;", "setCurrent", "(Lorg/ossreviewtoolkit/model/DependencyGraphNode;)V", "getGraph", "()Lorg/ossreviewtoolkit/model/DependencyGraph;", "id", "Lorg/ossreviewtoolkit/model/Identifier;", "getId", "()Lorg/ossreviewtoolkit/model/Identifier;", "getInitCurrent", "issues", "", "Lorg/ossreviewtoolkit/model/Issue;", "getIssues", "()Ljava/util/List;", "linkage", "Lorg/ossreviewtoolkit/model/PackageLinkage;", "getLinkage", "()Lorg/ossreviewtoolkit/model/PackageLinkage;", "nodesIterator", "", "asSequence", "Lkotlin/sequences/Sequence;", "equals", "", "other", "", "getInternalId", "getStableReference", "hashCode", "", "visitDependencies", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "model"})
final class DependencyRefCursor
implements DependencyNode {
    @NotNull
    private final DependencyGraph graph;
    @Nullable
    private final DependencyGraphNode initCurrent;
    @NotNull
    private final Iterator<DependencyGraphNode> nodesIterator;
    @NotNull
    private DependencyGraphNode current;

    public DependencyRefCursor(@NotNull DependencyGraph graph, @NotNull Collection<DependencyGraphNode> nodes, @Nullable DependencyGraphNode initCurrent) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.graph = graph;
        this.initCurrent = initCurrent;
        this.nodesIterator = nodes.iterator();
        DependencyGraphNode dependencyGraphNode = this.initCurrent;
        if (dependencyGraphNode == null) {
            dependencyGraphNode = this.nodesIterator.next();
        }
        this.current = dependencyGraphNode;
    }

    public /* synthetic */ DependencyRefCursor(DependencyGraph dependencyGraph, Collection collection, DependencyGraphNode dependencyGraphNode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            dependencyGraphNode = null;
        }
        this(dependencyGraph, collection, dependencyGraphNode);
    }

    @NotNull
    public final DependencyGraph getGraph() {
        return this.graph;
    }

    @Nullable
    public final DependencyGraphNode getInitCurrent() {
        return this.initCurrent;
    }

    @NotNull
    public final DependencyGraphNode getCurrent() {
        return this.current;
    }

    public final void setCurrent(@NotNull DependencyGraphNode dependencyGraphNode) {
        Intrinsics.checkNotNullParameter((Object)dependencyGraphNode, (String)"<set-?>");
        this.current = dependencyGraphNode;
    }

    @Override
    @NotNull
    public Identifier getId() {
        return this.graph.getPackages().get(this.current.getPkg());
    }

    @Override
    @NotNull
    public PackageLinkage getLinkage() {
        return this.current.getLinkage();
    }

    @Override
    @NotNull
    public List<Issue> getIssues() {
        return this.current.getIssues();
    }

    @Override
    public <T> T visitDependencies(@NotNull Function1<? super Sequence<? extends DependencyNode>, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return (T)block.invoke((Object)DependencyGraphNavigatorKt.access$dependenciesSequence(this.graph, (Collection)MapsKt.getValue(this.graph.getDependencies(), (Object)this.current)));
    }

    @Override
    @NotNull
    public DependencyNode getStableReference() {
        return new DependencyRefCursor(this.graph, null, this.current, 2, null);
    }

    @Override
    @NotNull
    public Object getInternalId() {
        return this.current;
    }

    @NotNull
    public final Sequence<DependencyNode> asSequence() {
        return SequencesKt.generateSequence((Object)this, (Function1)((Function1)new Function1<DependencyRefCursor, DependencyRefCursor>(this){
            final /* synthetic */ DependencyRefCursor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DependencyRefCursor invoke(@NotNull DependencyRefCursor it) {
                DependencyRefCursor dependencyRefCursor;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (DependencyRefCursor.access$getNodesIterator$p(this.this$0).hasNext()) {
                    this.this$0.setCurrent((DependencyGraphNode)DependencyRefCursor.access$getNodesIterator$p(this.this$0).next());
                    dependencyRefCursor = this.this$0;
                } else {
                    dependencyRefCursor = null;
                }
                return dependencyRefCursor;
            }
        }));
    }

    public boolean equals(@Nullable Object other) {
        DependencyRefCursor dependencyRefCursor = other instanceof DependencyRefCursor ? (DependencyRefCursor)other : null;
        return Intrinsics.areEqual((Object)(dependencyRefCursor != null ? dependencyRefCursor.current : null), (Object)this.current);
    }

    public int hashCode() {
        return this.current.hashCode();
    }

    public static final /* synthetic */ Iterator access$getNodesIterator$p(DependencyRefCursor $this) {
        return $this.nodesIterator;
    }
}

