/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.DependencyNavigator;
import org.ossreviewtoolkit.model.DependencyNode;
import org.ossreviewtoolkit.model.DependencyTreeNavigatorKt;
import org.ossreviewtoolkit.model.Identifier;
import org.ossreviewtoolkit.model.Issue;
import org.ossreviewtoolkit.model.PackageReference;
import org.ossreviewtoolkit.model.Project;
import org.ossreviewtoolkit.model.Scope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J>\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010H\u0016JB\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/ossreviewtoolkit/model/DependencyTreeNavigator;", "Lorg/ossreviewtoolkit/model/DependencyNavigator;", "()V", "dependenciesForScope", "", "Lorg/ossreviewtoolkit/model/Identifier;", "project", "Lorg/ossreviewtoolkit/model/Project;", "scopeName", "", "maxDepth", "", "matcher", "Lkotlin/Function1;", "Lorg/ossreviewtoolkit/model/DependencyNode;", "", "Lorg/ossreviewtoolkit/model/DependencyMatcher;", "directDependencies", "Lkotlin/sequences/Sequence;", "packageDependencies", "packageId", "scopeDependencies", "", "scopeNames", "model"})
@SourceDebugExtension(value={"SMAP\nDependencyTreeNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyTreeNavigator.kt\norg/ossreviewtoolkit/model/DependencyTreeNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1620#2,3:71\n1179#2,2:74\n1253#2,4:76\n1446#2,5:80\n*S KotlinDebug\n*F\n+ 1 DependencyTreeNavigator.kt\norg/ossreviewtoolkit/model/DependencyTreeNavigator\n*L\n27#1:71,3\n45#1:74,2\n45#1:76,4\n55#1:80,5\n*E\n"})
public final class DependencyTreeNavigator
implements DependencyNavigator {
    @NotNull
    public static final DependencyTreeNavigator INSTANCE = new DependencyTreeNavigator();

    private DependencyTreeNavigator() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> scopeNames(@NotNull Project project) {
        void var3_3;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = project.getScopes();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            Scope scope = (Scope)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(p0.getName());
        }
        return (Set)var3_3;
    }

    @Override
    @NotNull
    public Sequence<DependencyNode> directDependencies(@NotNull Project project, @NotNull String scopeName) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Object object = DependencyTreeNavigatorKt.access$findScope(project, scopeName);
        if ((object != null && (object = ((Scope)object).getDependencies()) != null ? CollectionsKt.asSequence((Iterable)((Iterable)object)) : (sequence = null)) == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @Override
    @NotNull
    public Set<Identifier> dependenciesForScope(@NotNull Project project, @NotNull String scopeName, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        Scope scope = DependencyTreeNavigatorKt.access$findScope(project, scopeName);
        Set<Identifier> set = scope != null ? scope.collectDependencies(maxDepth, (Function1<? super PackageReference, Boolean>)((Function1)new Function1<PackageReference, Boolean>(matcher2){
            final /* synthetic */ Function1<DependencyNode, Boolean> $matcher;
            {
                this.$matcher = $matcher;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PackageReference it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$matcher.invoke((Object)it);
            }
        })) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Set<Identifier>> scopeDependencies(@NotNull Project project, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        Iterable $this$associate$iv = project.getScopes();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Scope scope = (Scope)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)scope.getName(), scope.collectDependencies(maxDepth, (Function1<? super PackageReference, Boolean>)DependencyTreeNavigatorKt.access$forReference(matcher2)));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Identifier> packageDependencies(@NotNull Project project, @NotNull Identifier packageId, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        Intrinsics.checkNotNullParameter(matcher2, (String)"matcher");
        Iterable iterable = project.findReferences(packageId);
        Collection collection = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            PackageReference ref = (PackageReference)element$iv;
            boolean bl = false;
            Iterable list$iv = ref.collectDependencies(maxDepth, (Function1<? super PackageReference, Boolean>)DependencyTreeNavigatorKt.access$forReference(matcher2));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    @Override
    @NotNull
    public Map<String, Map<Identifier, List<Identifier>>> getShortestPaths(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.getShortestPaths(this, project);
    }

    @Override
    @NotNull
    public Set<Identifier> collectSubProjects(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.collectSubProjects(this, project);
    }

    @Override
    @NotNull
    public Set<Identifier> projectDependencies(@NotNull Project project, int maxDepth, @NotNull Function1<? super DependencyNode, Boolean> matcher2) {
        return DependencyNavigator.DefaultImpls.projectDependencies(this, project, maxDepth, matcher2);
    }

    @Override
    public int dependencyTreeDepth(@NotNull Project project, @NotNull String scopeName) {
        return DependencyNavigator.DefaultImpls.dependencyTreeDepth(this, project, scopeName);
    }

    @Override
    @NotNull
    public Map<Identifier, Set<Issue>> projectIssues(@NotNull Project project) {
        return DependencyNavigator.DefaultImpls.projectIssues(this, project);
    }
}

