/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.ossreviewtoolkit.model.MappersKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lorg/ossreviewtoolkit/model/FileFormat;", "", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "fileExtension", "", "aliases", "", "(Ljava/lang/String;ILcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/String;[Ljava/lang/String;)V", "getFileExtension", "()Ljava/lang/String;", "fileExtensions", "", "getFileExtensions", "()Ljava/util/List;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "JSON", "XML", "YAML", "Companion", "model"})
public final class FileFormat
extends Enum<FileFormat> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final String fileExtension;
    @NotNull
    private final List<String> fileExtensions;
    public static final /* enum */ FileFormat JSON;
    public static final /* enum */ FileFormat XML;
    public static final /* enum */ FileFormat YAML;
    private static final /* synthetic */ FileFormat[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private FileFormat(ObjectMapper mapper, String fileExtension, String ... aliases) {
        this.mapper = mapper;
        this.fileExtension = fileExtension;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this.fileExtension);
        spreadBuilder.addSpread((Object)aliases);
        this.fileExtensions = CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @NotNull
    public final ObjectMapper getMapper() {
        return this.mapper;
    }

    @NotNull
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @NotNull
    public final List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public static FileFormat[] values() {
        return (FileFormat[])$VALUES.clone();
    }

    public static FileFormat valueOf(String value2) {
        return Enum.valueOf(FileFormat.class, value2);
    }

    @NotNull
    public static EnumEntries<FileFormat> getEntries() {
        return $ENTRIES;
    }

    static {
        JSON = new FileFormat((ObjectMapper)MappersKt.getJsonMapper(), "json", new String[0]);
        XML = new FileFormat((ObjectMapper)MappersKt.getXmlMapper(), "xml", new String[0]);
        String[] stringArray = new String[]{"yaml"};
        YAML = new FileFormat((ObjectMapper)MappersKt.getYamlMapper(), "yml", stringArray);
        $VALUES = fileFormatArray = new FileFormat[]{FileFormat.JSON, FileFormat.XML, FileFormat.YAML};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Lorg/ossreviewtoolkit/model/FileFormat$Companion;", "", "()V", "findFilesWithKnownExtensions", "", "Ljava/io/File;", "directory", "forExtension", "Lorg/ossreviewtoolkit/model/FileFormat;", "extension", "", "forFile", "file", "model"})
    @SourceDebugExtension(value={"SMAP\nFileFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileFormat.kt\norg/ossreviewtoolkit/model/FileFormat$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1360#2:130\n1446#2,5:131\n*S KotlinDebug\n*F\n+ 1 FileFormat.kt\norg/ossreviewtoolkit/model/FileFormat$Companion\n*L\n73#1:130\n73#1:131,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileFormat forExtension(@NotNull String extension) {
            Object v1;
            block2: {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                String string = extension.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String lowerCaseExtension = string;
                boolean bl = false;
                Iterable iterable = (Iterable)FileFormat.getEntries();
                for (Object t : iterable) {
                    FileFormat it = (FileFormat)((Object)t);
                    boolean bl2 = false;
                    if (!it.getFileExtensions().contains(lowerCaseExtension)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            FileFormat fileFormat = v1;
            if (fileFormat == null) {
                throw new IllegalArgumentException("Unknown file format for file extension '" + extension + "'.");
            }
            return fileFormat;
        }

        @NotNull
        public final FileFormat forFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.forExtension(FilesKt.getExtension((File)file));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> findFilesWithKnownExtensions(@NotNull File directory) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Iterable $this$flatMap$iv = (Iterable)FileFormat.getEntries();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                FileFormat it = (FileFormat)((Object)element$iv$iv);
                boolean bl = false;
                Iterable list$iv$iv = it.getFileExtensions();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List allFileExtensions = (List)destination$iv$iv;
            return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkBottomUp((File)directory)), (Function1)((Function1)new Function1<File, Boolean>((List<String>)allFileExtensions){
                final /* synthetic */ List<String> $allFileExtensions;
                {
                    this.$allFileExtensions = $allFileExtensions;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.isFile() && this.$allFileExtensions.contains(FilesKt.getExtension((File)it));
                }
            })));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

