/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.KnownProvenance;
import org.ossreviewtoolkit.model.utils.FileListEntrySortedSetConverter;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0003\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/ossreviewtoolkit/model/FileList;", "", "provenance", "Lorg/ossreviewtoolkit/model/KnownProvenance;", "files", "", "Lorg/ossreviewtoolkit/model/FileList$Entry;", "(Lorg/ossreviewtoolkit/model/KnownProvenance;Ljava/util/Set;)V", "getFiles", "()Ljava/util/Set;", "getProvenance", "()Lorg/ossreviewtoolkit/model/KnownProvenance;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Entry", "model"})
public final class FileList {
    @NotNull
    private final KnownProvenance provenance;
    @NotNull
    private final Set<Entry> files;

    public FileList(@NotNull KnownProvenance provenance, @JsonSerialize(converter=FileListEntrySortedSetConverter.class) @NotNull Set<Entry> files) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.provenance = provenance;
        this.files = files;
        Set duplicateFilePaths = ExtensionsKt.getDuplicates((Collection)this.files, (Function1)1.INSTANCE).keySet();
        boolean bl = false;
        if (!duplicateFilePaths.isEmpty()) {
            boolean bl2 = false;
            String string = "Found duplicate file paths which is not allowed: " + CollectionsKt.joinToString$default((Iterable)duplicateFilePaths, null, null, null, (int)0, null, null, (int)63, null) + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final KnownProvenance getProvenance() {
        return this.provenance;
    }

    @NotNull
    public final Set<Entry> getFiles() {
        return this.files;
    }

    @NotNull
    public final KnownProvenance component1() {
        return this.provenance;
    }

    @NotNull
    public final Set<Entry> component2() {
        return this.files;
    }

    @NotNull
    public final FileList copy(@NotNull KnownProvenance provenance, @JsonSerialize(converter=FileListEntrySortedSetConverter.class) @NotNull Set<Entry> files) {
        Intrinsics.checkNotNullParameter((Object)provenance, (String)"provenance");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return new FileList(provenance, files);
    }

    public static /* synthetic */ FileList copy$default(FileList fileList, KnownProvenance knownProvenance, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            knownProvenance = fileList.provenance;
        }
        if ((n & 2) != 0) {
            set = fileList.files;
        }
        return fileList.copy(knownProvenance, set);
    }

    @NotNull
    public String toString() {
        return "FileList(provenance=" + this.provenance + ", files=" + this.files + ")";
    }

    public int hashCode() {
        int result = this.provenance.hashCode();
        result = result * 31 + ((Object)this.files).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileList)) {
            return false;
        }
        FileList fileList = (FileList)other;
        if (!Intrinsics.areEqual((Object)this.provenance, (Object)fileList.provenance)) {
            return false;
        }
        return Intrinsics.areEqual(this.files, fileList.files);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/ossreviewtoolkit/model/FileList$Entry;", "", "path", "", "sha1", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getSha1", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "model"})
    @SourceDebugExtension(value={"SMAP\nFileList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileList.kt\norg/ossreviewtoolkit/model/FileList$Entry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
    public static final class Entry {
        @NotNull
        private final String path;
        @NotNull
        private final String sha1;

        public Entry(@NotNull String path, @NotNull String sha1) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
            this.path = path;
            this.sha1 = sha1;
            if (!(!StringsKt.isBlank((CharSequence)this.path))) {
                boolean $i$a$-require-FileList$Entry$32 = false;
                String $i$a$-require-FileList$Entry$32 = "The path must not be blank.";
                throw new IllegalArgumentException($i$a$-require-FileList$Entry$32.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)this.sha1))) {
                boolean bl = false;
                String string = "The sha1 must not be blank.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getSha1() {
            return this.sha1;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.sha1;
        }

        @NotNull
        public final Entry copy(@NotNull String path, @NotNull String sha1) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
            return new Entry(path, sha1);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = entry.path;
            }
            if ((n & 2) != 0) {
                string2 = entry.sha1;
            }
            return entry.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Entry(path=" + this.path + ", sha1=" + this.sha1 + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.sha1.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)entry.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sha1, (Object)entry.sha1);
        }
    }
}

