/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.model.HashAlgorithm;
import org.ossreviewtoolkit.model.StringLowercaseConverter;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/ossreviewtoolkit/model/Hash;", "", "value", "", "algorithm", "Lorg/ossreviewtoolkit/model/HashAlgorithm;", "(Ljava/lang/String;Lorg/ossreviewtoolkit/model/HashAlgorithm;)V", "getAlgorithm", "()Lorg/ossreviewtoolkit/model/HashAlgorithm;", "getValue", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toSri", "toString", "verify", "file", "Ljava/io/File;", "hash", "Companion", "model"})
public final class Hash {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final HashAlgorithm algorithm;
    @NotNull
    private static final Hash NONE = new Hash(HashAlgorithm.NONE.toString(), HashAlgorithm.NONE);

    public Hash(@JsonSerialize(converter=StringLowercaseConverter.class) @NotNull String value2, @NotNull HashAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        this.value = value2;
        this.algorithm = algorithm;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final String toSri() {
        String string = this.algorithm.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string + "-" + Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])ExtensionsKt.decodeHex((String)this.value), (int)0, (int)0, (int)6, null);
    }

    public final boolean verify(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!HashAlgorithm.Companion.getVERIFIABLE().contains((Object)this.algorithm)) {
            boolean bl = false;
            String string = "Cannot verify algorithm '" + this.algorithm + "'. Supported algorithms are " + HashAlgorithm.Companion.getVERIFIABLE() + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return StringsKt.equals((String)this.algorithm.calculate(file), (String)this.value, (boolean)true);
    }

    public final boolean verify(@NotNull Hash hash) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.algorithm == hash.algorithm && StringsKt.equals((String)this.value, (String)hash.value, (boolean)true);
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final HashAlgorithm component2() {
        return this.algorithm;
    }

    @NotNull
    public final Hash copy(@JsonSerialize(converter=StringLowercaseConverter.class) @NotNull String value2, @NotNull HashAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        return new Hash(value2, algorithm);
    }

    public static /* synthetic */ Hash copy$default(Hash hash, String string, HashAlgorithm hashAlgorithm, int n, Object object) {
        if ((n & 1) != 0) {
            string = hash.value;
        }
        if ((n & 2) != 0) {
            hashAlgorithm = hash.algorithm;
        }
        return hash.copy(string, hashAlgorithm);
    }

    @NotNull
    public String toString() {
        return "Hash(value=" + this.value + ", algorithm=" + this.algorithm + ")";
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + this.algorithm.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Hash)) {
            return false;
        }
        Hash hash = (Hash)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)hash.value)) {
            return false;
        }
        return this.algorithm == hash.algorithm;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/ossreviewtoolkit/model/Hash$Companion;", "", "()V", "NONE", "Lorg/ossreviewtoolkit/model/Hash;", "getNONE", "()Lorg/ossreviewtoolkit/model/Hash;", "create", "value", "", "algorithm", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Hash getNONE() {
            return NONE;
        }

        @NotNull
        public final Hash create(@NotNull String value2) {
            Hash hash;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            char[] cArray = new char[]{'-'};
            List splitValue = StringsKt.split$default((CharSequence)value2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (splitValue.size() == 2) {
                hash = new Hash(ExtensionsKt.encodeHex((byte[])Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)((CharSequence)CollectionsKt.last((List)splitValue)), (int)0, (int)0, (int)6, null)), HashAlgorithm.Companion.fromString((String)CollectionsKt.first((List)splitValue)));
            } else {
                String string = value2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                hash = new Hash(string, HashAlgorithm.Companion.create(value2));
            }
            return hash;
        }

        @NotNull
        public final Hash create(@NotNull String value2, @NotNull String algorithm) {
            Hash hash;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Hash hash2 = hash = this.create(value2);
            boolean bl = false;
            if (!(hash2.getAlgorithm() == HashAlgorithm.Companion.fromString(algorithm))) {
                boolean bl2 = false;
                String string = "'" + value2 + "' is not a " + algorithm + " hash.";
                throw new IllegalArgumentException(string.toString());
            }
            return hash;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

