/*
 * Decompiled with CFR 0.152.
 */
package org.ossreviewtoolkit.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ossreviewtoolkit.utils.common.ExtensionsKt;
import org.ossreviewtoolkit.utils.common.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$B-\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u001b\u001a\u00020\u0004H\u0017R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000ej\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#\u00a8\u0006%"}, d2={"Lorg/ossreviewtoolkit/model/HashAlgorithm;", "", "aliases", "", "", "emptyValue", "isVerifiable", "", "(Ljava/lang/String;I[Ljava/lang/String;Ljava/lang/String;Z)V", "getAliases", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getEmptyValue", "()Ljava/lang/String;", "()Z", "calculate", "file", "Ljava/io/File;", "inputStream", "Ljava/io/InputStream;", "size", "", "bytes", "", "resourceName", "getMessageDigest", "Ljava/security/MessageDigest;", "toString", "NONE", "UNKNOWN", "MD5", "SHA1", "SHA256", "SHA384", "SHA512", "SHA1GIT", "Companion", "model"})
@SourceDebugExtension(value={"SMAP\nHashAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashAlgorithm.kt\norg/ossreviewtoolkit/model/HashAlgorithm\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n766#3:169\n857#3,2:170\n*S KotlinDebug\n*F\n+ 1 HashAlgorithm.kt\norg/ossreviewtoolkit/model/HashAlgorithm\n*L\n99#1:169\n99#1:170,2\n*E\n"})
public class HashAlgorithm
extends Enum<HashAlgorithm> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String[] aliases;
    @NotNull
    private final String emptyValue;
    private final boolean isVerifiable;
    @NotNull
    private static final List<HashAlgorithm> VERIFIABLE;
    public static final /* enum */ HashAlgorithm NONE;
    public static final /* enum */ HashAlgorithm UNKNOWN;
    public static final /* enum */ HashAlgorithm MD5;
    public static final /* enum */ HashAlgorithm SHA1;
    public static final /* enum */ HashAlgorithm SHA256;
    public static final /* enum */ HashAlgorithm SHA384;
    public static final /* enum */ HashAlgorithm SHA512;
    public static final /* enum */ HashAlgorithm SHA1GIT;
    private static final /* synthetic */ HashAlgorithm[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private HashAlgorithm(String[] aliases, String emptyValue, boolean isVerifiable) {
        this.aliases = aliases;
        this.emptyValue = emptyValue;
        this.isVerifiable = isVerifiable;
    }

    /* synthetic */ HashAlgorithm(String string, int n, String[] stringArray, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(stringArray, string2, bl);
    }

    @NotNull
    public final String[] getAliases() {
        return this.aliases;
    }

    @NotNull
    public final String getEmptyValue() {
        return this.emptyValue;
    }

    public final boolean isVerifiable() {
        return this.isVerifiable;
    }

    @JsonValue
    @NotNull
    public String toString() {
        return (String)ArraysKt.first((Object[])this.aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String calculate(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            string = this.calculate(it, file.length());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String calculate(@NotNull byte[] bytes2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        Closeable closeable = new ByteArrayInputStream(bytes2);
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            string = this.calculate(it, bytes2.length);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String calculate(@NotNull String resourceName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        URL resource = ((Object)((Object)this)).getClass().getResource(resourceName);
        Object object = resource;
        if (object == null || (object = ((URL)object).openConnection()) == null) {
            return null;
        }
        long size = ((URLConnection)object).getContentLengthLong();
        Closeable closeable = resource.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            string = this.calculate(it, size);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @NotNull
    protected MessageDigest getMessageDigest(long size) {
        MessageDigest messageDigest = MessageDigest.getInstance(this.toString());
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        return messageDigest;
    }

    private final String calculate(InputStream inputStream, long size) {
        return ExtensionsKt.encodeHex((byte[])UtilsKt.calculateHash((InputStream)inputStream, (MessageDigest)this.getMessageDigest(size)));
    }

    public static HashAlgorithm[] values() {
        return (HashAlgorithm[])$VALUES.clone();
    }

    public static HashAlgorithm valueOf(String value2) {
        return Enum.valueOf(HashAlgorithm.class, value2);
    }

    @NotNull
    public static EnumEntries<HashAlgorithm> getEntries() {
        return $ENTRIES;
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    @JvmStatic
    @NotNull
    public static final HashAlgorithm fromString(@NotNull String alias) {
        return Companion.fromString(alias);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{""};
        NONE = new HashAlgorithm(stringArray, "", false);
        stringArray = new String[]{"UNKNOWN"};
        UNKNOWN = new HashAlgorithm(stringArray, "", false);
        stringArray = new String[]{"MD5"};
        MD5 = new HashAlgorithm("MD5", 2, stringArray, "d41d8cd98f00b204e9800998ecf8427e", false, 4, null);
        stringArray = new String[]{"SHA-1", "SHA1"};
        SHA1 = new HashAlgorithm("SHA1", 3, stringArray, "da39a3ee5e6b4b0d3255bfef95601890afd80709", false, 4, null);
        stringArray = new String[]{"SHA-256", "SHA256"};
        SHA256 = new HashAlgorithm("SHA256", 4, stringArray, "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855", false, 4, null);
        stringArray = new String[]{"SHA-384", "SHA384"};
        SHA384 = new HashAlgorithm("SHA384", 5, stringArray, "38b060a751ac96384cd9327eb1b1e36a21fdb71114be07434c0cc7bf63f6e1da274edebfe76f65fbd51ad2f14898b95b", false, 4, null);
        stringArray = new String[]{"SHA-512", "SHA512"};
        SHA512 = new HashAlgorithm("SHA512", 6, stringArray, "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e", false, 4, null);
        SHA1GIT = new SHA1GIT("SHA1GIT", 7);
        $VALUES = hashAlgorithmArray = new HashAlgorithm[]{HashAlgorithm.NONE, HashAlgorithm.UNKNOWN, HashAlgorithm.MD5, HashAlgorithm.SHA1, HashAlgorithm.SHA256, HashAlgorithm.SHA384, HashAlgorithm.SHA512, HashAlgorithm.SHA1GIT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        Iterable $this$filter$iv = (Iterable)HashAlgorithm.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HashAlgorithm it = (HashAlgorithm)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.isVerifiable) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        VERIFIABLE = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/ossreviewtoolkit/model/HashAlgorithm$Companion;", "", "()V", "VERIFIABLE", "", "Lorg/ossreviewtoolkit/model/HashAlgorithm;", "getVERIFIABLE", "()Ljava/util/List;", "create", "value", "", "fromString", "alias", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<HashAlgorithm> getVERIFIABLE() {
            return VERIFIABLE;
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        @JvmStatic
        @NotNull
        public final HashAlgorithm fromString(@NotNull String alias) {
            HashAlgorithm hashAlgorithm;
            Object v2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                Iterable iterable = (Iterable)HashAlgorithm.getEntries();
                for (Object t : iterable) {
                    HashAlgorithm it = (HashAlgorithm)((Object)t);
                    boolean bl = false;
                    Object[] objectArray = it.getAliases();
                    String string = alias.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    if (!ArraysKt.contains((Object[])objectArray, (Object)string)) continue;
                    v2 = t;
                    break block2;
                }
                v2 = null;
            }
            if ((hashAlgorithm = (HashAlgorithm)v2) == null) {
                hashAlgorithm = UNKNOWN;
            }
            return hashAlgorithm;
        }

        @NotNull
        public final HashAlgorithm create(@NotNull String value2) {
            HashAlgorithm hashAlgorithm;
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (StringsKt.isBlank((CharSequence)value2)) {
                return NONE;
            }
            switch (value2.length()) {
                case 128: {
                    hashAlgorithm = SHA512;
                    break;
                }
                case 96: {
                    hashAlgorithm = SHA384;
                    break;
                }
                case 64: {
                    hashAlgorithm = SHA256;
                    break;
                }
                case 40: {
                    hashAlgorithm = SHA1;
                    break;
                }
                case 32: {
                    hashAlgorithm = MD5;
                    break;
                }
                default: {
                    hashAlgorithm = UNKNOWN;
                }
            }
            return hashAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/ossreviewtoolkit/model/HashAlgorithm$SHA1GIT;", "Lorg/ossreviewtoolkit/model/HashAlgorithm;", "getMessageDigest", "Ljava/security/MessageDigest;", "size", "", "model"})
    static final class SHA1GIT
    extends HashAlgorithm {
        /*
         * WARNING - void declaration
         */
        SHA1GIT() {
            void var1_1;
            String[] stringArray = new String[]{"SHA-1-GIT", "SHA1-GIT", "SHA1GIT", "SWHID"};
        }

        @Override
        @NotNull
        protected MessageDigest getMessageDigest(long size) {
            MessageDigest messageDigest;
            MessageDigest $this$getMessageDigest_u24lambda_u240 = messageDigest = MessageDigest.getInstance(SHA1.toString());
            boolean bl = false;
            String header = "blob " + size + "\u0000";
            byte[] byArray = header.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            $this$getMessageDigest_u24lambda_u240.update(byArray);
            MessageDigest messageDigest2 = messageDigest;
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"apply(...)");
            return messageDigest2;
        }
    }
}

